/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceChoice;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetReadAccessResult;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAck;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetServiceAckReadPropertyMultiple
extends BACnetServiceAck
implements Message {
    protected final List<BACnetReadAccessResult> data;
    protected final Long serviceAckPayloadLength;
    protected final Long serviceAckLength;

    @Override
    public BACnetConfirmedServiceChoice getServiceChoice() {
        return BACnetConfirmedServiceChoice.READ_PROPERTY_MULTIPLE;
    }

    public BACnetServiceAckReadPropertyMultiple(List<BACnetReadAccessResult> data, Long serviceAckPayloadLength, Long serviceAckLength) {
        super(serviceAckLength);
        this.data = data;
        this.serviceAckPayloadLength = serviceAckPayloadLength;
        this.serviceAckLength = serviceAckLength;
    }

    public List<BACnetReadAccessResult> getData() {
        return this.data;
    }

    @Override
    protected void serializeBACnetServiceAckChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetServiceAckReadPropertyMultiple", new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"data", this.data, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetServiceAckReadPropertyMultiple", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetServiceAckReadPropertyMultiple _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.data != null) {
            for (Message message : this.data) {
                lengthInBits += message.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static BACnetServiceAck.BACnetServiceAckBuilder staticParseBACnetServiceAckBuilder(ReadBuffer readBuffer, Long serviceAckPayloadLength, Long serviceAckLength) throws ParseException {
        readBuffer.pullContext("BACnetServiceAckReadPropertyMultiple", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        List data = FieldReaderFactory.readLengthArrayField((String)"data", (DataReader)new DataReaderComplexDefault(() -> BACnetReadAccessResult.staticParse(readBuffer), readBuffer), (long)serviceAckPayloadLength, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetServiceAckReadPropertyMultiple", new WithReaderArgs[0]);
        return new BACnetServiceAckReadPropertyMultipleBuilderImpl(data, serviceAckPayloadLength, serviceAckLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetServiceAckReadPropertyMultiple)) {
            return false;
        }
        BACnetServiceAckReadPropertyMultiple that = (BACnetServiceAckReadPropertyMultiple)o;
        return this.getData() == that.getData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetServiceAckReadPropertyMultipleBuilderImpl
    implements BACnetServiceAck.BACnetServiceAckBuilder {
        private final List<BACnetReadAccessResult> data;
        private final Long serviceAckPayloadLength;
        private final Long serviceAckLength;

        public BACnetServiceAckReadPropertyMultipleBuilderImpl(List<BACnetReadAccessResult> data, Long serviceAckPayloadLength, Long serviceAckLength) {
            this.data = data;
            this.serviceAckPayloadLength = serviceAckPayloadLength;
            this.serviceAckLength = serviceAckLength;
        }

        @Override
        public BACnetServiceAckReadPropertyMultiple build(Long serviceAckLength) {
            BACnetServiceAckReadPropertyMultiple bACnetServiceAckReadPropertyMultiple = new BACnetServiceAckReadPropertyMultiple(this.data, this.serviceAckPayloadLength, serviceAckLength);
            return bACnetServiceAckReadPropertyMultiple;
        }
    }
}

