/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetTagPayloadBoolean
implements Message {
    protected final Long actualLength;

    public BACnetTagPayloadBoolean(Long actualLength) {
        this.actualLength = actualLength;
    }

    public boolean getValue() {
        return this.actualLength == 1L;
    }

    public boolean getIsTrue() {
        return this.getValue();
    }

    public boolean getIsFalse() {
        return !this.getValue();
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetTagPayloadBoolean", new WithWriterArgs[0]);
        boolean value = this.getValue();
        writeBuffer.writeVirtual("value", (Object)value, new WithWriterArgs[0]);
        boolean isTrue = this.getIsTrue();
        writeBuffer.writeVirtual("isTrue", (Object)isTrue, new WithWriterArgs[0]);
        boolean isFalse = this.getIsFalse();
        writeBuffer.writeVirtual("isFalse", (Object)isFalse, new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetTagPayloadBoolean", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetTagPayloadBoolean _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits;
    }

    public static BACnetTagPayloadBoolean staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Long actualLength;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Long) {
            actualLength = (Long)args[0];
        } else if (args[0] instanceof String) {
            actualLength = Long.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Long or a string which is parseable but was " + args[0].getClass().getName());
        }
        return BACnetTagPayloadBoolean.staticParse(readBuffer, actualLength);
    }

    public static BACnetTagPayloadBoolean staticParse(ReadBuffer readBuffer, Long actualLength) throws ParseException {
        readBuffer.pullContext("BACnetTagPayloadBoolean", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        boolean value = (Boolean)FieldReaderFactory.readVirtualField((String)"value", Boolean.TYPE, (Object)(actualLength == 1L ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isTrue = (Boolean)FieldReaderFactory.readVirtualField((String)"isTrue", Boolean.TYPE, (Object)value, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isFalse = (Boolean)FieldReaderFactory.readVirtualField((String)"isFalse", Boolean.TYPE, (Object)(!value ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetTagPayloadBoolean", new WithReaderArgs[0]);
        BACnetTagPayloadBoolean _bACnetTagPayloadBoolean = new BACnetTagPayloadBoolean(actualLength);
        return _bACnetTagPayloadBoolean;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetTagPayloadBoolean)) {
            return false;
        }
        BACnetTagPayloadBoolean that = (BACnetTagPayloadBoolean)o;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

