/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetCharacterEncoding;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetTagPayloadCharacterString
implements Message {
    protected final BACnetCharacterEncoding encoding;
    protected final String value;
    protected final Long actualLength;

    public BACnetTagPayloadCharacterString(BACnetCharacterEncoding encoding, String value, Long actualLength) {
        this.encoding = encoding;
        this.value = value;
        this.actualLength = actualLength;
    }

    public BACnetCharacterEncoding getEncoding() {
        return this.encoding;
    }

    public String getValue() {
        return this.value;
    }

    public int getActualLengthInBit() {
        return (int)(this.actualLength * 8L - 8L);
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetTagPayloadCharacterString", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"encoding", (String)"BACnetCharacterEncoding", (Object)((Object)this.encoding), (DataWriter)new DataWriterEnumDefault(BACnetCharacterEncoding::getValue, Enum::name, DataWriterFactory.writeByte((WriteBuffer)writeBuffer, (int)8)), (WithWriterArgs[])new WithWriterArgs[0]);
        int actualLengthInBit = this.getActualLengthInBit();
        writeBuffer.writeVirtual("actualLengthInBit", (Object)actualLengthInBit, new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"value", (Object)this.value, (DataWriter)DataWriterFactory.writeString((WriteBuffer)writeBuffer, (int)actualLengthInBit), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithEncoding((String)"UTF-8")});
        writeBuffer.popContext("BACnetTagPayloadCharacterString", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetTagPayloadCharacterString _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        return lengthInBits += this.getActualLengthInBit();
    }

    public static BACnetTagPayloadCharacterString staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Long actualLength;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Long) {
            actualLength = (Long)args[0];
        } else if (args[0] instanceof String) {
            actualLength = Long.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Long or a string which is parseable but was " + args[0].getClass().getName());
        }
        return BACnetTagPayloadCharacterString.staticParse(readBuffer, actualLength);
    }

    public static BACnetTagPayloadCharacterString staticParse(ReadBuffer readBuffer, Long actualLength) throws ParseException {
        readBuffer.pullContext("BACnetTagPayloadCharacterString", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetCharacterEncoding encoding = (BACnetCharacterEncoding)((Object)FieldReaderFactory.readEnumField((String)"encoding", (String)"BACnetCharacterEncoding", (DataReader)new DataReaderEnumDefault(BACnetCharacterEncoding::enumForValue, DataReaderFactory.readByte((ReadBuffer)readBuffer, (int)8)), (WithReaderArgs[])new WithReaderArgs[0]));
        int actualLengthInBit = (Integer)FieldReaderFactory.readVirtualField((String)"actualLengthInBit", Integer.TYPE, (Object)(actualLength * 8L - 8L), (WithReaderArgs[])new WithReaderArgs[0]);
        String value = (String)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readString((ReadBuffer)readBuffer, (int)actualLengthInBit), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithEncoding((String)"UTF-8")});
        readBuffer.closeContext("BACnetTagPayloadCharacterString", new WithReaderArgs[0]);
        BACnetTagPayloadCharacterString _bACnetTagPayloadCharacterString = new BACnetTagPayloadCharacterString(encoding, value, actualLength);
        return _bACnetTagPayloadCharacterString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetTagPayloadCharacterString)) {
            return false;
        }
        BACnetTagPayloadCharacterString that = (BACnetTagPayloadCharacterString)o;
        return this.getEncoding() == that.getEncoding() && this.getValue() == that.getValue();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getEncoding(), this.getValue()});
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

