/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetObjectType;
import org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetTagPayloadObjectIdentifier
implements Message {
    protected final BACnetObjectType objectType;
    protected final short proprietaryValue;
    protected final int instanceNumber;

    public BACnetTagPayloadObjectIdentifier(BACnetObjectType objectType, short proprietaryValue, int instanceNumber) {
        this.objectType = objectType;
        this.proprietaryValue = proprietaryValue;
        this.instanceNumber = instanceNumber;
    }

    public BACnetObjectType getObjectType() {
        return this.objectType;
    }

    public short getProprietaryValue() {
        return this.proprietaryValue;
    }

    public int getInstanceNumber() {
        return this.instanceNumber;
    }

    public boolean getIsProprietary() {
        return this.getObjectType() == BACnetObjectType.VENDOR_PROPRIETARY_VALUE;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetTagPayloadObjectIdentifier", new WithWriterArgs[0]);
        FieldWriterFactory.writeManualField((String)"objectType", () -> StaticHelper.writeObjectType(writeBuffer, this.objectType), (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeManualField((String)"proprietaryValue", () -> StaticHelper.writeProprietaryObjectType(writeBuffer, this.objectType, this.proprietaryValue), (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        boolean isProprietary = this.getIsProprietary();
        writeBuffer.writeVirtual("isProprietary", (Object)isProprietary, new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"instanceNumber", (Object)this.instanceNumber, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)22), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetTagPayloadObjectIdentifier", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetTagPayloadObjectIdentifier _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 10;
        lengthInBits += 0;
        return lengthInBits += 22;
    }

    public static BACnetTagPayloadObjectIdentifier staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return BACnetTagPayloadObjectIdentifier.staticParse(readBuffer);
    }

    public static BACnetTagPayloadObjectIdentifier staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("BACnetTagPayloadObjectIdentifier", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetObjectType objectType = (BACnetObjectType)((Object)FieldReaderFactory.readManualField((String)"objectType", (ReadBuffer)readBuffer, () -> StaticHelper.readObjectType(readBuffer), (WithReaderArgs[])new WithReaderArgs[0]));
        short proprietaryValue = (Short)FieldReaderFactory.readManualField((String)"proprietaryValue", (ReadBuffer)readBuffer, () -> (short)StaticHelper.readProprietaryObjectType(readBuffer, objectType), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isProprietary = (Boolean)FieldReaderFactory.readVirtualField((String)"isProprietary", Boolean.TYPE, (Object)(objectType == BACnetObjectType.VENDOR_PROPRIETARY_VALUE ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        int instanceNumber = (Integer)FieldReaderFactory.readSimpleField((String)"instanceNumber", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)22), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetTagPayloadObjectIdentifier", new WithReaderArgs[0]);
        BACnetTagPayloadObjectIdentifier _bACnetTagPayloadObjectIdentifier = new BACnetTagPayloadObjectIdentifier(objectType, proprietaryValue, instanceNumber);
        return _bACnetTagPayloadObjectIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetTagPayloadObjectIdentifier)) {
            return false;
        }
        BACnetTagPayloadObjectIdentifier that = (BACnetTagPayloadObjectIdentifier)o;
        return this.getObjectType() == that.getObjectType() && this.getProprietaryValue() == that.getProprietaryValue() && this.getInstanceNumber() == that.getInstanceNumber();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getObjectType(), this.getProprietaryValue(), this.getInstanceNumber()});
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

