/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetTagPayloadOctetString
implements Message {
    protected final byte[] octets;
    protected final Long actualLength;

    public BACnetTagPayloadOctetString(byte[] octets, Long actualLength) {
        this.octets = octets;
        this.actualLength = actualLength;
    }

    public byte[] getOctets() {
        return this.octets;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetTagPayloadOctetString", new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"octets", (byte[])this.octets, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetTagPayloadOctetString", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetTagPayloadOctetString _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.octets != null) {
            lengthInBits += 8 * this.octets.length;
        }
        return lengthInBits;
    }

    public static BACnetTagPayloadOctetString staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Long actualLength;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Long) {
            actualLength = (Long)args[0];
        } else if (args[0] instanceof String) {
            actualLength = Long.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Long or a string which is parseable but was " + args[0].getClass().getName());
        }
        return BACnetTagPayloadOctetString.staticParse(readBuffer, actualLength);
    }

    public static BACnetTagPayloadOctetString staticParse(ReadBuffer readBuffer, Long actualLength) throws ParseException {
        readBuffer.pullContext("BACnetTagPayloadOctetString", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        byte[] octets = readBuffer.readByteArray("octets", Math.toIntExact(actualLength), new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetTagPayloadOctetString", new WithReaderArgs[0]);
        BACnetTagPayloadOctetString _bACnetTagPayloadOctetString = new BACnetTagPayloadOctetString(octets, actualLength);
        return _bACnetTagPayloadOctetString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetTagPayloadOctetString)) {
            return false;
        }
        BACnetTagPayloadOctetString that = (BACnetTagPayloadOctetString)o;
        return this.getOctets() == that.getOctets();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getOctets()});
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

