/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.math.BigInteger;
import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ParseValidationException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetTagPayloadSignedInteger
implements Message {
    protected final Byte valueInt8;
    protected final Short valueInt16;
    protected final Integer valueInt24;
    protected final Integer valueInt32;
    protected final Long valueInt40;
    protected final Long valueInt48;
    protected final Long valueInt56;
    protected final Long valueInt64;
    protected final Long actualLength;

    public BACnetTagPayloadSignedInteger(Byte valueInt8, Short valueInt16, Integer valueInt24, Integer valueInt32, Long valueInt40, Long valueInt48, Long valueInt56, Long valueInt64, Long actualLength) {
        this.valueInt8 = valueInt8;
        this.valueInt16 = valueInt16;
        this.valueInt24 = valueInt24;
        this.valueInt32 = valueInt32;
        this.valueInt40 = valueInt40;
        this.valueInt48 = valueInt48;
        this.valueInt56 = valueInt56;
        this.valueInt64 = valueInt64;
        this.actualLength = actualLength;
    }

    public Byte getValueInt8() {
        return this.valueInt8;
    }

    public Short getValueInt16() {
        return this.valueInt16;
    }

    public Integer getValueInt24() {
        return this.valueInt24;
    }

    public Integer getValueInt32() {
        return this.valueInt32;
    }

    public Long getValueInt40() {
        return this.valueInt40;
    }

    public Long getValueInt48() {
        return this.valueInt48;
    }

    public Long getValueInt56() {
        return this.valueInt56;
    }

    public Long getValueInt64() {
        return this.valueInt64;
    }

    public boolean getIsInt8() {
        return this.actualLength == 1L;
    }

    public boolean getIsInt16() {
        return this.actualLength == 2L;
    }

    public boolean getIsInt24() {
        return this.actualLength == 3L;
    }

    public boolean getIsInt32() {
        return this.actualLength == 4L;
    }

    public boolean getIsInt40() {
        return this.actualLength == 5L;
    }

    public boolean getIsInt48() {
        return this.actualLength == 6L;
    }

    public boolean getIsInt56() {
        return this.actualLength == 7L;
    }

    public boolean getIsInt64() {
        return this.actualLength == 8L;
    }

    public BigInteger getActualValue() {
        Long o = this.getIsInt8() ? (long)this.getValueInt8().byteValue() : (this.getIsInt16() ? (long)this.getValueInt16().shortValue() : (this.getIsInt24() ? (long)this.getValueInt24().intValue() : (this.getIsInt32() ? (long)this.getValueInt32().intValue() : (this.getIsInt40() ? this.getValueInt40() : (this.getIsInt48() ? this.getValueInt48() : (this.getIsInt56() ? this.getValueInt56() : this.getValueInt64()))))));
        if (o instanceof BigInteger) {
            return (BigInteger)((Object)o);
        }
        return BigInteger.valueOf(((Number)o).longValue());
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetTagPayloadSignedInteger", new WithWriterArgs[0]);
        boolean isInt8 = this.getIsInt8();
        writeBuffer.writeVirtual("isInt8", (Object)isInt8, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"valueInt8", (Object)this.valueInt8, (DataWriter)DataWriterFactory.writeSignedByte((WriteBuffer)writeBuffer, (int)8), (boolean)this.getIsInt8(), (WithWriterArgs[])new WithWriterArgs[0]);
        boolean isInt16 = this.getIsInt16();
        writeBuffer.writeVirtual("isInt16", (Object)isInt16, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"valueInt16", (Object)this.valueInt16, (DataWriter)DataWriterFactory.writeSignedShort((WriteBuffer)writeBuffer, (int)16), (boolean)this.getIsInt16(), (WithWriterArgs[])new WithWriterArgs[0]);
        boolean isInt24 = this.getIsInt24();
        writeBuffer.writeVirtual("isInt24", (Object)isInt24, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"valueInt24", (Object)this.valueInt24, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)24), (boolean)this.getIsInt24(), (WithWriterArgs[])new WithWriterArgs[0]);
        boolean isInt32 = this.getIsInt32();
        writeBuffer.writeVirtual("isInt32", (Object)isInt32, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"valueInt32", (Object)this.valueInt32, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (boolean)this.getIsInt32(), (WithWriterArgs[])new WithWriterArgs[0]);
        boolean isInt40 = this.getIsInt40();
        writeBuffer.writeVirtual("isInt40", (Object)isInt40, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"valueInt40", (Object)this.valueInt40, (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)40), (boolean)this.getIsInt40(), (WithWriterArgs[])new WithWriterArgs[0]);
        boolean isInt48 = this.getIsInt48();
        writeBuffer.writeVirtual("isInt48", (Object)isInt48, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"valueInt48", (Object)this.valueInt48, (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)48), (boolean)this.getIsInt48(), (WithWriterArgs[])new WithWriterArgs[0]);
        boolean isInt56 = this.getIsInt56();
        writeBuffer.writeVirtual("isInt56", (Object)isInt56, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"valueInt56", (Object)this.valueInt56, (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)56), (boolean)this.getIsInt56(), (WithWriterArgs[])new WithWriterArgs[0]);
        boolean isInt64 = this.getIsInt64();
        writeBuffer.writeVirtual("isInt64", (Object)isInt64, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"valueInt64", (Object)this.valueInt64, (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)64), (boolean)this.getIsInt64(), (WithWriterArgs[])new WithWriterArgs[0]);
        BigInteger actualValue = this.getActualValue();
        writeBuffer.writeVirtual("actualValue", (Object)actualValue, new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetTagPayloadSignedInteger", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetTagPayloadSignedInteger _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.valueInt8 != null) {
            lengthInBits += 8;
        }
        if (this.valueInt16 != null) {
            lengthInBits += 16;
        }
        if (this.valueInt24 != null) {
            lengthInBits += 24;
        }
        if (this.valueInt32 != null) {
            lengthInBits += 32;
        }
        if (this.valueInt40 != null) {
            lengthInBits += 40;
        }
        if (this.valueInt48 != null) {
            lengthInBits += 48;
        }
        if (this.valueInt56 != null) {
            lengthInBits += 56;
        }
        if (this.valueInt64 != null) {
            lengthInBits += 64;
        }
        return lengthInBits;
    }

    public static BACnetTagPayloadSignedInteger staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Long actualLength;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Long) {
            actualLength = (Long)args[0];
        } else if (args[0] instanceof String) {
            actualLength = Long.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Long or a string which is parseable but was " + args[0].getClass().getName());
        }
        return BACnetTagPayloadSignedInteger.staticParse(readBuffer, actualLength);
    }

    public static BACnetTagPayloadSignedInteger staticParse(ReadBuffer readBuffer, Long actualLength) throws ParseException {
        readBuffer.pullContext("BACnetTagPayloadSignedInteger", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        boolean isInt8 = (Boolean)FieldReaderFactory.readVirtualField((String)"isInt8", Boolean.TYPE, (Object)(actualLength == 1L ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        Byte valueInt8 = (Byte)FieldReaderFactory.readOptionalField((String)"valueInt8", (DataReader)DataReaderFactory.readSignedByte((ReadBuffer)readBuffer, (int)8), (boolean)isInt8, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isInt16 = (Boolean)FieldReaderFactory.readVirtualField((String)"isInt16", Boolean.TYPE, (Object)(actualLength == 2L ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        Short valueInt16 = (Short)FieldReaderFactory.readOptionalField((String)"valueInt16", (DataReader)DataReaderFactory.readSignedShort((ReadBuffer)readBuffer, (int)16), (boolean)isInt16, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isInt24 = (Boolean)FieldReaderFactory.readVirtualField((String)"isInt24", Boolean.TYPE, (Object)(actualLength == 3L ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        Integer valueInt24 = (Integer)FieldReaderFactory.readOptionalField((String)"valueInt24", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)24), (boolean)isInt24, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isInt32 = (Boolean)FieldReaderFactory.readVirtualField((String)"isInt32", Boolean.TYPE, (Object)(actualLength == 4L ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        Integer valueInt32 = (Integer)FieldReaderFactory.readOptionalField((String)"valueInt32", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (boolean)isInt32, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isInt40 = (Boolean)FieldReaderFactory.readVirtualField((String)"isInt40", Boolean.TYPE, (Object)(actualLength == 5L ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        Long valueInt40 = (Long)FieldReaderFactory.readOptionalField((String)"valueInt40", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)40), (boolean)isInt40, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isInt48 = (Boolean)FieldReaderFactory.readVirtualField((String)"isInt48", Boolean.TYPE, (Object)(actualLength == 6L ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        Long valueInt48 = (Long)FieldReaderFactory.readOptionalField((String)"valueInt48", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)48), (boolean)isInt48, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isInt56 = (Boolean)FieldReaderFactory.readVirtualField((String)"isInt56", Boolean.TYPE, (Object)(actualLength == 7L ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        Long valueInt56 = (Long)FieldReaderFactory.readOptionalField((String)"valueInt56", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)56), (boolean)isInt56, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isInt64 = (Boolean)FieldReaderFactory.readVirtualField((String)"isInt64", Boolean.TYPE, (Object)(actualLength == 8L ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        Long valueInt64 = (Long)FieldReaderFactory.readOptionalField((String)"valueInt64", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)64), (boolean)isInt64, (WithReaderArgs[])new WithReaderArgs[0]);
        if (!(isInt8 || isInt16 || isInt24 || isInt32 || isInt40 || isInt48 || isInt56 || isInt64)) {
            throw new ParseValidationException("unmapped integer length");
        }
        BigInteger actualValue = (BigInteger)FieldReaderFactory.readVirtualField((String)"actualValue", BigInteger.class, (Object)(isInt8 ? (long)valueInt8.byteValue() : (isInt16 ? (long)valueInt16.shortValue() : (isInt24 ? (long)valueInt24.intValue() : (isInt32 ? (long)valueInt32.intValue() : (isInt40 ? valueInt40 : (isInt48 ? valueInt48 : (isInt56 ? valueInt56 : valueInt64))))))), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetTagPayloadSignedInteger", new WithReaderArgs[0]);
        BACnetTagPayloadSignedInteger _bACnetTagPayloadSignedInteger = new BACnetTagPayloadSignedInteger(valueInt8, valueInt16, valueInt24, valueInt32, valueInt40, valueInt48, valueInt56, valueInt64, actualLength);
        return _bACnetTagPayloadSignedInteger;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetTagPayloadSignedInteger)) {
            return false;
        }
        BACnetTagPayloadSignedInteger that = (BACnetTagPayloadSignedInteger)o;
        return this.getValueInt8() == that.getValueInt8() && this.getValueInt16() == that.getValueInt16() && this.getValueInt24() == that.getValueInt24() && this.getValueInt32() == that.getValueInt32() && this.getValueInt40() == that.getValueInt40() && this.getValueInt48() == that.getValueInt48() && this.getValueInt56() == that.getValueInt56() && this.getValueInt64() == that.getValueInt64();
    }

    public int hashCode() {
        return Objects.hash(this.getValueInt8(), this.getValueInt16(), this.getValueInt24(), this.getValueInt32(), this.getValueInt40(), this.getValueInt48(), this.getValueInt56(), this.getValueInt64());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

