/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagOctetString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDataType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetVMACEntry
implements Message {
    protected final BACnetContextTagOctetString virtualMacAddress;
    protected final BACnetContextTagOctetString nativeMacAddress;

    public BACnetVMACEntry(BACnetContextTagOctetString virtualMacAddress, BACnetContextTagOctetString nativeMacAddress) {
        this.virtualMacAddress = virtualMacAddress;
        this.nativeMacAddress = nativeMacAddress;
    }

    public BACnetContextTagOctetString getVirtualMacAddress() {
        return this.virtualMacAddress;
    }

    public BACnetContextTagOctetString getNativeMacAddress() {
        return this.nativeMacAddress;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetVMACEntry", new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"virtualMacAddress", (Object)this.virtualMacAddress, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"nativeMacAddress", (Object)this.nativeMacAddress, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetVMACEntry", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetVMACEntry _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.virtualMacAddress != null) {
            lengthInBits += this.virtualMacAddress.getLengthInBits();
        }
        if (this.nativeMacAddress != null) {
            lengthInBits += this.nativeMacAddress.getLengthInBits();
        }
        return lengthInBits;
    }

    public static BACnetVMACEntry staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return BACnetVMACEntry.staticParse(readBuffer);
    }

    public static BACnetVMACEntry staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("BACnetVMACEntry", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetContextTagOctetString virtualMacAddress = (BACnetContextTagOctetString)FieldReaderFactory.readOptionalField((String)"virtualMacAddress", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagOctetString)BACnetContextTag.staticParse(readBuffer, (short)0, BACnetDataType.OCTET_STRING), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetContextTagOctetString nativeMacAddress = (BACnetContextTagOctetString)FieldReaderFactory.readOptionalField((String)"nativeMacAddress", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagOctetString)BACnetContextTag.staticParse(readBuffer, (short)1, BACnetDataType.OCTET_STRING), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetVMACEntry", new WithReaderArgs[0]);
        BACnetVMACEntry _bACnetVMACEntry = new BACnetVMACEntry(virtualMacAddress, nativeMacAddress);
        return _bACnetVMACEntry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetVMACEntry)) {
            return false;
        }
        BACnetVMACEntry that = (BACnetVMACEntry)o;
        return this.getVirtualMacAddress() == that.getVirtualMacAddress() && this.getNativeMacAddress() == that.getNativeMacAddress();
    }

    public int hashCode() {
        return Objects.hash(this.getVirtualMacAddress(), this.getNativeMacAddress());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

