/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseAssertException;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ParseValidationException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetWeekNDayTagged
implements Message {
    protected final BACnetTagHeader header;
    protected final short month;
    protected final short weekOfMonth;
    protected final short dayOfWeek;
    protected final Short tagNumber;
    protected final TagClass tagClass;

    public BACnetWeekNDayTagged(BACnetTagHeader header, short month, short weekOfMonth, short dayOfWeek, Short tagNumber, TagClass tagClass) {
        this.header = header;
        this.month = month;
        this.weekOfMonth = weekOfMonth;
        this.dayOfWeek = dayOfWeek;
        this.tagNumber = tagNumber;
        this.tagClass = tagClass;
    }

    public BACnetTagHeader getHeader() {
        return this.header;
    }

    public short getMonth() {
        return this.month;
    }

    public short getWeekOfMonth() {
        return this.weekOfMonth;
    }

    public short getDayOfWeek() {
        return this.dayOfWeek;
    }

    public boolean getOddMonths() {
        return this.getMonth() == 13;
    }

    public boolean getEvenMonths() {
        return this.getMonth() == 14;
    }

    public boolean getAnyMonth() {
        return this.getMonth() == 255;
    }

    public boolean getDays1to7() {
        return this.getWeekOfMonth() == 1;
    }

    public boolean getDays8to14() {
        return this.getWeekOfMonth() == 2;
    }

    public boolean getDays15to21() {
        return this.getWeekOfMonth() == 3;
    }

    public boolean getDays22to28() {
        return this.getWeekOfMonth() == 4;
    }

    public boolean getDays29to31() {
        return this.getWeekOfMonth() == 5;
    }

    public boolean getLast7DaysOfThisMonth() {
        return this.getWeekOfMonth() == 6;
    }

    public boolean getAny7DaysPriorToLast7DaysOfThisMonth() {
        return this.getWeekOfMonth() == 7;
    }

    public boolean getAny7DaysPriorToLast14DaysOfThisMonth() {
        return this.getWeekOfMonth() == 8;
    }

    public boolean getAny7DaysPriorToLast21DaysOfThisMonth() {
        return this.getWeekOfMonth() == 9;
    }

    public boolean getAnyWeekOfthisMonth() {
        return this.getWeekOfMonth() == 255;
    }

    public boolean getAnyDayOfWeek() {
        return this.getDayOfWeek() == 255;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetWeekNDayTagged", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"header", (Object)this.header, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"month", (Object)this.month, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        boolean oddMonths = this.getOddMonths();
        writeBuffer.writeVirtual("oddMonths", (Object)oddMonths, new WithWriterArgs[0]);
        boolean evenMonths = this.getEvenMonths();
        writeBuffer.writeVirtual("evenMonths", (Object)evenMonths, new WithWriterArgs[0]);
        boolean anyMonth = this.getAnyMonth();
        writeBuffer.writeVirtual("anyMonth", (Object)anyMonth, new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"weekOfMonth", (Object)this.weekOfMonth, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        boolean days1to7 = this.getDays1to7();
        writeBuffer.writeVirtual("days1to7", (Object)days1to7, new WithWriterArgs[0]);
        boolean days8to14 = this.getDays8to14();
        writeBuffer.writeVirtual("days8to14", (Object)days8to14, new WithWriterArgs[0]);
        boolean days15to21 = this.getDays15to21();
        writeBuffer.writeVirtual("days15to21", (Object)days15to21, new WithWriterArgs[0]);
        boolean days22to28 = this.getDays22to28();
        writeBuffer.writeVirtual("days22to28", (Object)days22to28, new WithWriterArgs[0]);
        boolean days29to31 = this.getDays29to31();
        writeBuffer.writeVirtual("days29to31", (Object)days29to31, new WithWriterArgs[0]);
        boolean last7DaysOfThisMonth = this.getLast7DaysOfThisMonth();
        writeBuffer.writeVirtual("last7DaysOfThisMonth", (Object)last7DaysOfThisMonth, new WithWriterArgs[0]);
        boolean any7DaysPriorToLast7DaysOfThisMonth = this.getAny7DaysPriorToLast7DaysOfThisMonth();
        writeBuffer.writeVirtual("any7DaysPriorToLast7DaysOfThisMonth", (Object)any7DaysPriorToLast7DaysOfThisMonth, new WithWriterArgs[0]);
        boolean any7DaysPriorToLast14DaysOfThisMonth = this.getAny7DaysPriorToLast14DaysOfThisMonth();
        writeBuffer.writeVirtual("any7DaysPriorToLast14DaysOfThisMonth", (Object)any7DaysPriorToLast14DaysOfThisMonth, new WithWriterArgs[0]);
        boolean any7DaysPriorToLast21DaysOfThisMonth = this.getAny7DaysPriorToLast21DaysOfThisMonth();
        writeBuffer.writeVirtual("any7DaysPriorToLast21DaysOfThisMonth", (Object)any7DaysPriorToLast21DaysOfThisMonth, new WithWriterArgs[0]);
        boolean anyWeekOfthisMonth = this.getAnyWeekOfthisMonth();
        writeBuffer.writeVirtual("anyWeekOfthisMonth", (Object)anyWeekOfthisMonth, new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"dayOfWeek", (Object)this.dayOfWeek, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        boolean anyDayOfWeek = this.getAnyDayOfWeek();
        writeBuffer.writeVirtual("anyDayOfWeek", (Object)anyDayOfWeek, new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetWeekNDayTagged", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetWeekNDayTagged _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.header.getLengthInBits();
        lengthInBits += 8;
        lengthInBits += 8;
        return lengthInBits += 8;
    }

    public static BACnetWeekNDayTagged staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        TagClass tagClass;
        Short tagNumber;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 2) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 2, but got " + args.length);
        }
        if (args[0] instanceof Short) {
            tagNumber = (Short)args[0];
        } else if (args[0] instanceof String) {
            tagNumber = Short.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Short or a string which is parseable but was " + args[0].getClass().getName());
        }
        if (args[1] instanceof TagClass) {
            tagClass = (TagClass)((Object)args[1]);
        } else if (args[1] instanceof String) {
            tagClass = TagClass.valueOf((String)args[1]);
        } else {
            throw new PlcRuntimeException("Argument 1 expected to be of type TagClass or a string which is parseable but was " + args[1].getClass().getName());
        }
        return BACnetWeekNDayTagged.staticParse(readBuffer, tagNumber, tagClass);
    }

    public static BACnetWeekNDayTagged staticParse(ReadBuffer readBuffer, Short tagNumber, TagClass tagClass) throws ParseException {
        readBuffer.pullContext("BACnetWeekNDayTagged", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetTagHeader header = (BACnetTagHeader)FieldReaderFactory.readSimpleField((String)"header", (DataReader)new DataReaderComplexDefault(() -> BACnetTagHeader.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        if (header.getTagClass() != tagClass) {
            throw new ParseValidationException("tag class doesn't match");
        }
        if (header.getTagClass() != TagClass.APPLICATION_TAGS && header.getActualTagNumber() != tagNumber.shortValue()) {
            throw new ParseAssertException("tagnumber doesn't match");
        }
        if (header.getActualLength() != 3L) {
            throw new ParseValidationException("We should have at least 3 octets");
        }
        short month = (Short)FieldReaderFactory.readSimpleField((String)"month", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean oddMonths = (Boolean)FieldReaderFactory.readVirtualField((String)"oddMonths", Boolean.TYPE, (Object)(month == 13 ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean evenMonths = (Boolean)FieldReaderFactory.readVirtualField((String)"evenMonths", Boolean.TYPE, (Object)(month == 14 ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean anyMonth = (Boolean)FieldReaderFactory.readVirtualField((String)"anyMonth", Boolean.TYPE, (Object)(month == 255 ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        short weekOfMonth = (Short)FieldReaderFactory.readSimpleField((String)"weekOfMonth", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean days1to7 = (Boolean)FieldReaderFactory.readVirtualField((String)"days1to7", Boolean.TYPE, (Object)(weekOfMonth == 1 ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean days8to14 = (Boolean)FieldReaderFactory.readVirtualField((String)"days8to14", Boolean.TYPE, (Object)(weekOfMonth == 2 ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean days15to21 = (Boolean)FieldReaderFactory.readVirtualField((String)"days15to21", Boolean.TYPE, (Object)(weekOfMonth == 3 ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean days22to28 = (Boolean)FieldReaderFactory.readVirtualField((String)"days22to28", Boolean.TYPE, (Object)(weekOfMonth == 4 ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean days29to31 = (Boolean)FieldReaderFactory.readVirtualField((String)"days29to31", Boolean.TYPE, (Object)(weekOfMonth == 5 ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean last7DaysOfThisMonth = (Boolean)FieldReaderFactory.readVirtualField((String)"last7DaysOfThisMonth", Boolean.TYPE, (Object)(weekOfMonth == 6 ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean any7DaysPriorToLast7DaysOfThisMonth = (Boolean)FieldReaderFactory.readVirtualField((String)"any7DaysPriorToLast7DaysOfThisMonth", Boolean.TYPE, (Object)(weekOfMonth == 7 ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean any7DaysPriorToLast14DaysOfThisMonth = (Boolean)FieldReaderFactory.readVirtualField((String)"any7DaysPriorToLast14DaysOfThisMonth", Boolean.TYPE, (Object)(weekOfMonth == 8 ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean any7DaysPriorToLast21DaysOfThisMonth = (Boolean)FieldReaderFactory.readVirtualField((String)"any7DaysPriorToLast21DaysOfThisMonth", Boolean.TYPE, (Object)(weekOfMonth == 9 ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean anyWeekOfthisMonth = (Boolean)FieldReaderFactory.readVirtualField((String)"anyWeekOfthisMonth", Boolean.TYPE, (Object)(weekOfMonth == 255 ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        short dayOfWeek = (Short)FieldReaderFactory.readSimpleField((String)"dayOfWeek", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean anyDayOfWeek = (Boolean)FieldReaderFactory.readVirtualField((String)"anyDayOfWeek", Boolean.TYPE, (Object)(dayOfWeek == 255 ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetWeekNDayTagged", new WithReaderArgs[0]);
        BACnetWeekNDayTagged _bACnetWeekNDayTagged = new BACnetWeekNDayTagged(header, month, weekOfMonth, dayOfWeek, tagNumber, tagClass);
        return _bACnetWeekNDayTagged;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetWeekNDayTagged)) {
            return false;
        }
        BACnetWeekNDayTagged that = (BACnetWeekNDayTagged)o;
        return this.getHeader() == that.getHeader() && this.getMonth() == that.getMonth() && this.getWeekOfMonth() == that.getWeekOfMonth() && this.getDayOfWeek() == that.getDayOfWeek();
    }

    public int hashCode() {
        return Objects.hash(this.getHeader(), this.getMonth(), this.getWeekOfMonth(), this.getDayOfWeek());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

