/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BVLC;
import org.apache.plc4x.java.bacnetip.readwrite.NPDU;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BVLCForwardedNPDU
extends BVLC
implements Message {
    protected final List<Short> ip;
    protected final int port;
    protected final NPDU npdu;
    protected final Integer bvlcPayloadLength;

    @Override
    public Short getBvlcFunction() {
        return (short)4;
    }

    public BVLCForwardedNPDU(List<Short> ip, int port, NPDU npdu, Integer bvlcPayloadLength) {
        this.ip = ip;
        this.port = port;
        this.npdu = npdu;
        this.bvlcPayloadLength = bvlcPayloadLength;
    }

    public List<Short> getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public NPDU getNpdu() {
        return this.npdu;
    }

    @Override
    protected void serializeBVLCChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BVLCForwardedNPDU", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"ip", this.ip, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeSimpleField((String)"port", (Object)this.port, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeSimpleField((String)"npdu", (Object)this.npdu, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        writeBuffer.popContext("BVLCForwardedNPDU", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BVLCForwardedNPDU _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.ip != null) {
            lengthInBits += 8 * this.ip.size();
        }
        lengthInBits += 16;
        return lengthInBits += this.npdu.getLengthInBits();
    }

    public static BVLC.BVLCBuilder staticParseBVLCBuilder(ReadBuffer readBuffer, Integer bvlcPayloadLength) throws ParseException {
        readBuffer.pullContext("BVLCForwardedNPDU", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        List ip = FieldReaderFactory.readCountArrayField((String)"ip", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (long)4L, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        int port = (Integer)FieldReaderFactory.readSimpleField((String)"port", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        NPDU npdu = (NPDU)FieldReaderFactory.readSimpleField((String)"npdu", (DataReader)new DataReaderComplexDefault(() -> NPDU.staticParse(readBuffer, bvlcPayloadLength - 6), readBuffer), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        readBuffer.closeContext("BVLCForwardedNPDU", new WithReaderArgs[0]);
        return new BVLCForwardedNPDUBuilderImpl(ip, port, npdu, bvlcPayloadLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BVLCForwardedNPDU)) {
            return false;
        }
        BVLCForwardedNPDU that = (BVLCForwardedNPDU)o;
        return this.getIp() == that.getIp() && this.getPort() == that.getPort() && this.getNpdu() == that.getNpdu() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getIp(), this.getPort(), this.getNpdu());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BVLCForwardedNPDUBuilderImpl
    implements BVLC.BVLCBuilder {
        private final List<Short> ip;
        private final int port;
        private final NPDU npdu;
        private final Integer bvlcPayloadLength;

        public BVLCForwardedNPDUBuilderImpl(List<Short> ip, int port, NPDU npdu, Integer bvlcPayloadLength) {
            this.ip = ip;
            this.port = port;
            this.npdu = npdu;
            this.bvlcPayloadLength = bvlcPayloadLength;
        }

        @Override
        public BVLCForwardedNPDU build() {
            BVLCForwardedNPDU bVLCForwardedNPDU = new BVLCForwardedNPDU(this.ip, this.port, this.npdu, this.bvlcPayloadLength);
            return bVLCForwardedNPDU;
        }
    }
}

