/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.NLM;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class NLMChallengeRequest
extends NLM
implements Message {
    protected final byte messageChallenge;
    protected final long originalMessageId;
    protected final long originalTimestamp;
    protected final Integer apduLength;

    @Override
    public Short getMessageType() {
        return (short)10;
    }

    public NLMChallengeRequest(byte messageChallenge, long originalMessageId, long originalTimestamp, Integer apduLength) {
        super(apduLength);
        this.messageChallenge = messageChallenge;
        this.originalMessageId = originalMessageId;
        this.originalTimestamp = originalTimestamp;
        this.apduLength = apduLength;
    }

    public byte getMessageChallenge() {
        return this.messageChallenge;
    }

    public long getOriginalMessageId() {
        return this.originalMessageId;
    }

    public long getOriginalTimestamp() {
        return this.originalTimestamp;
    }

    @Override
    protected void serializeNLMChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("NLMChallengeRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"messageChallenge", (Object)this.messageChallenge, (DataWriter)DataWriterFactory.writeByte((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"originalMessageId", (Object)this.originalMessageId, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"originalTimestamp", (Object)this.originalTimestamp, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("NLMChallengeRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        NLMChallengeRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 32;
        return lengthInBits += 32;
    }

    public static NLM.NLMBuilder staticParseNLMBuilder(ReadBuffer readBuffer, Integer apduLength) throws ParseException {
        readBuffer.pullContext("NLMChallengeRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        byte messageChallenge = (Byte)FieldReaderFactory.readSimpleField((String)"messageChallenge", (DataReader)DataReaderFactory.readByte((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        long originalMessageId = (Long)FieldReaderFactory.readSimpleField((String)"originalMessageId", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        long originalTimestamp = (Long)FieldReaderFactory.readSimpleField((String)"originalTimestamp", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("NLMChallengeRequest", new WithReaderArgs[0]);
        return new NLMChallengeRequestBuilderImpl(messageChallenge, originalMessageId, originalTimestamp, apduLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NLMChallengeRequest)) {
            return false;
        }
        NLMChallengeRequest that = (NLMChallengeRequest)o;
        return this.getMessageChallenge() == that.getMessageChallenge() && this.getOriginalMessageId() == that.getOriginalMessageId() && this.getOriginalTimestamp() == that.getOriginalTimestamp() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMessageChallenge(), this.getOriginalMessageId(), this.getOriginalTimestamp());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class NLMChallengeRequestBuilderImpl
    implements NLM.NLMBuilder {
        private final byte messageChallenge;
        private final long originalMessageId;
        private final long originalTimestamp;
        private final Integer apduLength;

        public NLMChallengeRequestBuilderImpl(byte messageChallenge, long originalMessageId, long originalTimestamp, Integer apduLength) {
            this.messageChallenge = messageChallenge;
            this.originalMessageId = originalMessageId;
            this.originalTimestamp = originalTimestamp;
            this.apduLength = apduLength;
        }

        @Override
        public NLMChallengeRequest build(Integer apduLength) {
            NLMChallengeRequest nLMChallengeRequest = new NLMChallengeRequest(this.messageChallenge, this.originalMessageId, this.originalTimestamp, apduLength);
            return nLMChallengeRequest;
        }
    }
}

