/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.NLM;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class NLMRequestMasterKey
extends NLM
implements Message {
    protected final short numberOfSupportedKeyAlgorithms;
    protected final byte[] encryptionAndSignatureAlgorithms;
    protected final Integer apduLength;

    @Override
    public Short getMessageType() {
        return (short)16;
    }

    public NLMRequestMasterKey(short numberOfSupportedKeyAlgorithms, byte[] encryptionAndSignatureAlgorithms, Integer apduLength) {
        super(apduLength);
        this.numberOfSupportedKeyAlgorithms = numberOfSupportedKeyAlgorithms;
        this.encryptionAndSignatureAlgorithms = encryptionAndSignatureAlgorithms;
        this.apduLength = apduLength;
    }

    public short getNumberOfSupportedKeyAlgorithms() {
        return this.numberOfSupportedKeyAlgorithms;
    }

    public byte[] getEncryptionAndSignatureAlgorithms() {
        return this.encryptionAndSignatureAlgorithms;
    }

    @Override
    protected void serializeNLMChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("NLMRequestMasterKey", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"numberOfSupportedKeyAlgorithms", (Object)this.numberOfSupportedKeyAlgorithms, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"encryptionAndSignatureAlgorithms", (byte[])this.encryptionAndSignatureAlgorithms, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("NLMRequestMasterKey", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        NLMRequestMasterKey _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        if (this.encryptionAndSignatureAlgorithms != null) {
            lengthInBits += 8 * this.encryptionAndSignatureAlgorithms.length;
        }
        return lengthInBits;
    }

    public static NLM.NLMBuilder staticParseNLMBuilder(ReadBuffer readBuffer, Integer apduLength) throws ParseException {
        readBuffer.pullContext("NLMRequestMasterKey", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        short numberOfSupportedKeyAlgorithms = (Short)FieldReaderFactory.readSimpleField((String)"numberOfSupportedKeyAlgorithms", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] encryptionAndSignatureAlgorithms = readBuffer.readByteArray("encryptionAndSignatureAlgorithms", Math.toIntExact(apduLength - 2), new WithReaderArgs[0]);
        readBuffer.closeContext("NLMRequestMasterKey", new WithReaderArgs[0]);
        return new NLMRequestMasterKeyBuilderImpl(numberOfSupportedKeyAlgorithms, encryptionAndSignatureAlgorithms, apduLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NLMRequestMasterKey)) {
            return false;
        }
        NLMRequestMasterKey that = (NLMRequestMasterKey)o;
        return this.getNumberOfSupportedKeyAlgorithms() == that.getNumberOfSupportedKeyAlgorithms() && this.getEncryptionAndSignatureAlgorithms() == that.getEncryptionAndSignatureAlgorithms() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNumberOfSupportedKeyAlgorithms(), this.getEncryptionAndSignatureAlgorithms());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class NLMRequestMasterKeyBuilderImpl
    implements NLM.NLMBuilder {
        private final short numberOfSupportedKeyAlgorithms;
        private final byte[] encryptionAndSignatureAlgorithms;
        private final Integer apduLength;

        public NLMRequestMasterKeyBuilderImpl(short numberOfSupportedKeyAlgorithms, byte[] encryptionAndSignatureAlgorithms, Integer apduLength) {
            this.numberOfSupportedKeyAlgorithms = numberOfSupportedKeyAlgorithms;
            this.encryptionAndSignatureAlgorithms = encryptionAndSignatureAlgorithms;
            this.apduLength = apduLength;
        }

        @Override
        public NLMRequestMasterKey build(Integer apduLength) {
            NLMRequestMasterKey nLMRequestMasterKey = new NLMRequestMasterKey(this.numberOfSupportedKeyAlgorithms, this.encryptionAndSignatureAlgorithms, apduLength);
            return nLMRequestMasterKey;
        }
    }
}

