/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.NLM;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class NLMReserved
extends NLM
implements Message {
    protected final byte[] unknownBytes;
    protected final Integer apduLength;

    @Override
    public Short getMessageType() {
        return (short)0;
    }

    public NLMReserved(byte[] unknownBytes, Integer apduLength) {
        super(apduLength);
        this.unknownBytes = unknownBytes;
        this.apduLength = apduLength;
    }

    public byte[] getUnknownBytes() {
        return this.unknownBytes;
    }

    @Override
    protected void serializeNLMChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("NLMReserved", new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"unknownBytes", (byte[])this.unknownBytes, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("NLMReserved", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        NLMReserved _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.unknownBytes != null) {
            lengthInBits += 8 * this.unknownBytes.length;
        }
        return lengthInBits;
    }

    public static NLM.NLMBuilder staticParseNLMBuilder(ReadBuffer readBuffer, Integer apduLength) throws ParseException {
        readBuffer.pullContext("NLMReserved", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        byte[] unknownBytes = readBuffer.readByteArray("unknownBytes", Math.toIntExact(apduLength > 0 ? apduLength - 1 : 0), new WithReaderArgs[0]);
        readBuffer.closeContext("NLMReserved", new WithReaderArgs[0]);
        return new NLMReservedBuilderImpl(unknownBytes, apduLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NLMReserved)) {
            return false;
        }
        NLMReserved that = (NLMReserved)o;
        return this.getUnknownBytes() == that.getUnknownBytes() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getUnknownBytes());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class NLMReservedBuilderImpl
    implements NLM.NLMBuilder {
        private final byte[] unknownBytes;
        private final Integer apduLength;

        public NLMReservedBuilderImpl(byte[] unknownBytes, Integer apduLength) {
            this.unknownBytes = unknownBytes;
            this.apduLength = apduLength;
        }

        @Override
        public NLMReserved build(Integer apduLength) {
            NLMReserved nLMReserved = new NLMReserved(this.unknownBytes, apduLength);
            return nLMReserved;
        }
    }
}

