/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.NLM;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class NLMSecurityPayload
extends NLM
implements Message {
    protected final int payloadLength;
    protected final byte[] payload;
    protected final Integer apduLength;

    @Override
    public Short getMessageType() {
        return (short)11;
    }

    public NLMSecurityPayload(int payloadLength, byte[] payload, Integer apduLength) {
        super(apduLength);
        this.payloadLength = payloadLength;
        this.payload = payload;
        this.apduLength = apduLength;
    }

    public int getPayloadLength() {
        return this.payloadLength;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    protected void serializeNLMChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("NLMSecurityPayload", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"payloadLength", (Object)this.payloadLength, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"payload", (byte[])this.payload, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("NLMSecurityPayload", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        NLMSecurityPayload _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        if (this.payload != null) {
            lengthInBits += 8 * this.payload.length;
        }
        return lengthInBits;
    }

    public static NLM.NLMBuilder staticParseNLMBuilder(ReadBuffer readBuffer, Integer apduLength) throws ParseException {
        readBuffer.pullContext("NLMSecurityPayload", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int payloadLength = (Integer)FieldReaderFactory.readSimpleField((String)"payloadLength", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] payload = readBuffer.readByteArray("payload", Math.toIntExact(payloadLength), new WithReaderArgs[0]);
        readBuffer.closeContext("NLMSecurityPayload", new WithReaderArgs[0]);
        return new NLMSecurityPayloadBuilderImpl(payloadLength, payload, apduLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NLMSecurityPayload)) {
            return false;
        }
        NLMSecurityPayload that = (NLMSecurityPayload)o;
        return this.getPayloadLength() == that.getPayloadLength() && this.getPayload() == that.getPayload() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getPayloadLength(), this.getPayload());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class NLMSecurityPayloadBuilderImpl
    implements NLM.NLMBuilder {
        private final int payloadLength;
        private final byte[] payload;
        private final Integer apduLength;

        public NLMSecurityPayloadBuilderImpl(int payloadLength, byte[] payload, Integer apduLength) {
            this.payloadLength = payloadLength;
            this.payload = payload;
            this.apduLength = apduLength;
        }

        @Override
        public NLMSecurityPayload build(Integer apduLength) {
            NLMSecurityPayload nLMSecurityPayload = new NLMSecurityPayload(this.payloadLength, this.payload, apduLength);
            return nLMSecurityPayload;
        }
    }
}

