/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.tag;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcValueType;

public class BacNetIpTag
implements PlcTag {
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("TODO: finish me... see golang implementation");
    public static final int INT_WILDCARD = -1;
    public static final long LONG_WILDCARD = -1L;
    private final long deviceIdentifier;
    private final int objectType;
    private final long objectInstance;

    public static boolean matches(String tagString) {
        return ADDRESS_PATTERN.matcher(tagString).matches();
    }

    public static BacNetIpTag of(String tagString) {
        Matcher matcher = ADDRESS_PATTERN.matcher(tagString);
        if (matcher.matches()) {
            long deviceIdentifier = matcher.group("deviceIdentifier").equals("*") ? -1L : Long.parseLong(matcher.group("deviceIdentifier"));
            int objectType = matcher.group("objectType").equals("*") ? -1 : Integer.parseInt(matcher.group("objectType"));
            long objectInstance = matcher.group("objectInstance").equals("*") ? -1L : Long.parseLong(matcher.group("objectInstance"));
            return new BacNetIpTag(deviceIdentifier, objectType, objectInstance);
        }
        throw new PlcInvalidTagException("Unable to parse address: " + tagString);
    }

    public BacNetIpTag(long deviceIdentifier, int objectType, long objectInstance) {
        this.deviceIdentifier = deviceIdentifier;
        this.objectType = objectType;
        this.objectInstance = objectInstance;
    }

    public String getAddressString() {
        return "TODO: finish me... see golang implementation";
    }

    public PlcValueType getPlcValueType() {
        return super.getPlcValueType();
    }

    public List<ArrayInfo> getArrayInfo() {
        return super.getArrayInfo();
    }

    public long getDeviceIdentifier() {
        return this.deviceIdentifier;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public long getObjectInstance() {
        return this.objectInstance;
    }

    public boolean matches(BacNetIpTag otherTag) {
        return !(this.deviceIdentifier != -1L && this.deviceIdentifier != otherTag.deviceIdentifier || this.objectType != -1 && this.objectType != otherTag.objectType || this.objectInstance != -1L && this.objectInstance != otherTag.objectInstance);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BacNetIpTag)) {
            return false;
        }
        BacNetIpTag that = (BacNetIpTag)o;
        return new EqualsBuilder().append(this.getDeviceIdentifier(), that.getDeviceIdentifier()).append(this.getObjectType(), that.getObjectType()).append(this.getObjectInstance(), that.getObjectInstance()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.getDeviceIdentifier()).append(this.getObjectType()).append(this.getObjectInstance()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("deviceIdentifier", this.deviceIdentifier).append("objectType", this.objectType).append("objectInstance", this.objectInstance).toString();
    }
}

