/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.bacnetip.configuration.BacNetIpConfiguration;
import org.apache.plc4x.java.bacnetip.configuration.BacNetPcapReplayTransportConfiguration;
import org.apache.plc4x.java.bacnetip.configuration.BacNetRawSocketTransportConfiguration;
import org.apache.plc4x.java.bacnetip.configuration.BacNetUdpTransportConfiguration;
import org.apache.plc4x.java.bacnetip.protocol.BacNetIpProtocolLogic;
import org.apache.plc4x.java.bacnetip.readwrite.BVLC;
import org.apache.plc4x.java.bacnetip.tag.BacNetIpTagHandler;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcTransportConfiguration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;
import org.apache.plc4x.java.spi.values.PlcValueHandler;

public class BacNetIpDriver
extends GeneratedDriverBase<BVLC> {
    public String getProtocolCode() {
        return "bacnet-ip";
    }

    public String getProtocolName() {
        return "BACnet/IP";
    }

    protected Class<? extends PlcConnectionConfiguration> getConfigurationClass() {
        return BacNetIpConfiguration.class;
    }

    protected Optional<Class<? extends PlcTransportConfiguration>> getTransportConfigurationClass(String transportCode) {
        switch (transportCode) {
            case "udp": {
                return Optional.of(BacNetUdpTransportConfiguration.class);
            }
            case "raw": {
                return Optional.of(BacNetRawSocketTransportConfiguration.class);
            }
            case "pcap": {
                return Optional.of(BacNetPcapReplayTransportConfiguration.class);
            }
        }
        return Optional.empty();
    }

    protected Optional<String> getDefaultTransportCode() {
        return Optional.of("udp");
    }

    protected List<String> getSupportedTransportCodes() {
        return Arrays.asList("udp", "tcp", "pcap");
    }

    protected boolean canRead() {
        return false;
    }

    protected boolean canWrite() {
        return false;
    }

    protected boolean canSubscribe() {
        return true;
    }

    protected BacNetIpTagHandler getTagHandler() {
        return new BacNetIpTagHandler();
    }

    protected org.apache.plc4x.java.api.value.PlcValueHandler getValueHandler() {
        return new PlcValueHandler();
    }

    protected ProtocolStackConfigurer<BVLC> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(BVLC.class, (readBuffer, objectArray) -> BVLC.staticParse(readBuffer, objectArray)).withProtocol(BacNetIpProtocolLogic.class).withPacketSizeEstimator(ByteLengthEstimator.class).withCorruptPacketRemover(CorruptPackageCleaner.class).build();
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 4) {
                return byteBuf.getUnsignedShort(byteBuf.readerIndex() + 2);
            }
            return -1;
        }
    }

    public static class CorruptPackageCleaner
    implements Consumer<ByteBuf> {
        @Override
        public void accept(ByteBuf byteBuf) {
            while (byteBuf.getUnsignedByte(0) != BVLC.BACNETTYPE.shortValue()) {
                byteBuf.readByte();
            }
        }
    }
}

