/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.configuration;

import org.apache.plc4x.java.bacnetip.readwrite.BacnetConstants;
import org.apache.plc4x.java.spi.configuration.annotations.ConfigurationParameter;
import org.apache.plc4x.java.spi.configuration.annotations.Description;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.BooleanDefaultValue;
import org.apache.plc4x.java.transport.rawsocket.DefaultRawSocketTransportConfiguration;
import org.apache.plc4x.java.utils.pcap.netty.handlers.PacketHandler;
import org.pcap4j.packet.Dot1qVlanTagPacket;

public class BacNetRawSocketTransportConfiguration
extends DefaultRawSocketTransportConfiguration {
    @ConfigurationParameter(value="resolve-mac-address")
    @BooleanDefaultValue(value=true)
    @Description(value="Controls, if mac-addresses should be resolved upon connection.")
    private boolean resolveMacAddress;

    public boolean isResolveMacAccess() {
        return this.resolveMacAddress;
    }

    public void setResolveMacAddress(boolean resolveMacAddress) {
        this.resolveMacAddress = resolveMacAddress;
    }

    public int getDefaultPort() {
        return BacnetConstants.BACNETUDPDEFAULTPORT;
    }

    public PacketHandler getPcapPacketHandler() {
        return packet -> {
            if (packet.getPayload() instanceof Dot1qVlanTagPacket) {
                return packet.getPayload().getPayload().getPayload().getPayload().getRawData();
            }
            if (packet.getPayload() != null && packet.getPayload().getPayload() != null && packet.getPayload().getPayload().getPayload() != null) {
                return packet.getPayload().getPayload().getPayload().getRawData();
            }
            return null;
        };
    }
}

