/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.ede;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.bacnetip.ede.layouts.EdeLayout;
import org.apache.plc4x.java.bacnetip.ede.layouts.EdeLayoutFactory;
import org.apache.plc4x.java.bacnetip.ede.model.Datapoint;
import org.apache.plc4x.java.bacnetip.ede.model.EdeModel;
import org.apache.plc4x.java.bacnetip.tag.BacNetIpTag;

public class EdeParser {
    public EdeModel parseDirectory(File edeDirectory) {
        HashMap<BacNetIpTag, Datapoint> datapoints = new HashMap<BacNetIpTag, Datapoint>();
        List<File> edeFiles = this.findAllEdeFiles(edeDirectory);
        try {
            for (File edeFile : edeFiles) {
                datapoints.putAll(this.parseFileDatapoints(edeFile));
            }
        }
        catch (Exception e) {
            throw new PlcRuntimeException("Error parsing EDE files", (Throwable)e);
        }
        return new EdeModel(datapoints);
    }

    public EdeModel parseFile(File edeFile) {
        if (!edeFile.exists()) {
            throw new PlcRuntimeException("EDE File at " + edeFile.getPath() + " doesn't exist.");
        }
        return new EdeModel(this.parseFileDatapoints(edeFile));
    }

    private List<File> findAllEdeFiles(File curDir) {
        final LinkedList<File> edeFiles = new LinkedList<File>();
        try {
            Files.walkFileTree(curDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                    File file = path.toFile();
                    if (file.isFile()) {
                        if (file.getName().startsWith("edeDataText")) {
                            String suffix = file.getName().substring("edeDataText".length());
                            File stateFile = new File(file.getParentFile(), "edeStateText" + suffix);
                            if (stateFile.exists() && stateFile.isFile()) {
                                edeFiles.add(path.toFile());
                            }
                        }
                    } else if (file.isDirectory()) {
                        edeFiles.addAll(EdeParser.this.findAllEdeFiles(file));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new PlcRuntimeException("Error scanning EDE directories", (Throwable)e);
        }
        return edeFiles;
    }

    private Map<BacNetIpTag, Datapoint> parseFileDatapoints(File edeFile) {
        try {
            FileReader in = new FileReader(edeFile);
            CSVParser parser = CSVFormat.newFormat((char)';').parse((Reader)in);
            Iterator iterator = parser.iterator();
            int i = 0;
            while (i < 5) {
                if (!iterator.hasNext()) {
                    throw new PlcRuntimeException("Invalid EDE file format");
                }
                iterator.next();
                ++i;
            }
            CSVRecord layoutVersionRow = (CSVRecord)iterator.next();
            EdeLayout edeLayout = EdeLayoutFactory.getLayoutForVersion(this.safeCastInteger(layoutVersionRow, 1));
            if (edeLayout == null) {
                throw new PlcRuntimeException("rted EDE file layout version " + layoutVersionRow.get(1));
            }
            iterator.next();
            CSVRecord columnNames = (CSVRecord)iterator.next();
            HashMap<BacNetIpTag, Datapoint> datapoints = new HashMap<BacNetIpTag, Datapoint>();
            iterator.forEachRemaining(record -> {
                Long deviceInstance = this.safeCastLong((CSVRecord)record, edeLayout.getDeviceInstancePos());
                Integer objectType = this.safeCastInteger((CSVRecord)record, edeLayout.getObjectTypePos());
                Long objectInstance = this.safeCastLong((CSVRecord)record, edeLayout.getObjectInstancePos());
                if (deviceInstance == null || objectType == null || objectInstance == null) {
                    return;
                }
                BacNetIpTag address = new BacNetIpTag(deviceInstance, objectType, objectInstance);
                String keyName = this.safeString((CSVRecord)record, edeLayout.getKeyNamePos());
                String objectName = this.safeString((CSVRecord)record, edeLayout.getObjectNamePos());
                String description = this.safeString((CSVRecord)record, edeLayout.getDescriptionPos());
                Double defaultValue = this.safeCastDouble((CSVRecord)record, edeLayout.getDefaultValuePos());
                Double minValue = this.safeCastDouble((CSVRecord)record, edeLayout.getMinValuePos());
                Double maxValue = this.safeCastDouble((CSVRecord)record, edeLayout.getMaxValuePos());
                Boolean commandable = this.safeCastBoolean((CSVRecord)record, edeLayout.getCommandablePos());
                Boolean supportsCov = this.safeCastBoolean((CSVRecord)record, edeLayout.getSupportsCovPos());
                Double hiLimit = this.safeCastDouble((CSVRecord)record, edeLayout.getHiLimitPos());
                Double lowLimit = this.safeCastDouble((CSVRecord)record, edeLayout.getLowLimitPos());
                String stateTextReference = this.safeString((CSVRecord)record, edeLayout.getStateTextReferencePos());
                Integer unitCode = this.safeCastInteger((CSVRecord)record, edeLayout.getUnitCodePos());
                Integer vendorSpecificAddress = this.safeCastInteger((CSVRecord)record, edeLayout.getVendorSpecificAddressPos());
                Integer notificationClass = this.safeCastInteger((CSVRecord)record, edeLayout.getNotificationClassPos());
                Datapoint datapoint = new Datapoint(address, keyName, objectName, description, defaultValue, minValue, maxValue, commandable, supportsCov, hiLimit, lowLimit, stateTextReference, unitCode, vendorSpecificAddress, notificationClass);
                datapoints.put(address, datapoint);
            });
            return datapoints;
        }
        catch (IOException e) {
            throw new PlcRuntimeException("Error parsing EDE file", (Throwable)e);
        }
    }

    private String safeString(CSVRecord record, int pos) {
        if (pos == -1 || record.get(pos) == null || record.get(pos).isEmpty()) {
            return null;
        }
        return record.get(pos);
    }

    private Double safeCastDouble(CSVRecord record, int pos) {
        if (pos == -1) {
            return null;
        }
        try {
            return Double.valueOf(record.get(pos).replace(",", "."));
        }
        catch (Exception e) {
            return null;
        }
    }

    private Long safeCastLong(CSVRecord record, int pos) {
        if (pos == -1) {
            return null;
        }
        try {
            return Long.valueOf(record.get(pos));
        }
        catch (Exception e) {
            return null;
        }
    }

    private Integer safeCastInteger(CSVRecord record, int pos) {
        if (pos == -1) {
            return null;
        }
        try {
            return Integer.valueOf(record.get(pos));
        }
        catch (Exception e) {
            return null;
        }
    }

    private Boolean safeCastBoolean(CSVRecord record, int pos) {
        if (pos == -1) {
            return null;
        }
        try {
            switch (record.get(pos)) {
                case "Y": {
                    return true;
                }
                case "N": {
                    return false;
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

