/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.bacnetip.readwrite.APDUAbort;
import org.apache.plc4x.java.bacnetip.readwrite.APDUComplexAck;
import org.apache.plc4x.java.bacnetip.readwrite.APDUConfirmedRequest;
import org.apache.plc4x.java.bacnetip.readwrite.APDUError;
import org.apache.plc4x.java.bacnetip.readwrite.APDUReject;
import org.apache.plc4x.java.bacnetip.readwrite.APDUSegmentAck;
import org.apache.plc4x.java.bacnetip.readwrite.APDUSimpleAck;
import org.apache.plc4x.java.bacnetip.readwrite.APDUUnconfirmedRequest;
import org.apache.plc4x.java.bacnetip.readwrite.APDUUnknown;
import org.apache.plc4x.java.bacnetip.readwrite.ApduType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class APDU
implements Message {
    protected final Integer apduLength;

    public abstract ApduType getApduType();

    public APDU(Integer apduLength) {
        this.apduLength = apduLength;
    }

    protected abstract void serializeAPDUChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("APDU", new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorEnumField((String)"apduType", (String)"ApduType", (Object)((Object)this.getApduType()), (DataWriter)new DataWriterEnumDefault(ApduType::getValue, Enum::name, DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)4)), (WithWriterArgs[])new WithWriterArgs[0]);
        this.serializeAPDUChild(writeBuffer);
        writeBuffer.popContext("APDU", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        APDU _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits += 4;
    }

    public static APDU staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Integer apduLength;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Integer) {
            apduLength = (Integer)args[0];
        } else if (args[0] instanceof String) {
            apduLength = Integer.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Integer or a string which is parseable but was " + args[0].getClass().getName());
        }
        return APDU.staticParse(readBuffer, apduLength);
    }

    public static APDU staticParse(ReadBuffer readBuffer, Integer apduLength) throws ParseException {
        readBuffer.pullContext("APDU", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        ApduType apduType = (ApduType)((Object)FieldReaderFactory.readDiscriminatorEnumField((String)"apduType", (String)"ApduType", (DataReader)new DataReaderEnumDefault(ApduType::enumForValue, DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)4)), (WithReaderArgs[])new WithReaderArgs[0]));
        APDUBuilder builder = null;
        builder = EvaluationHelper.equals((Object)((Object)apduType), (Object)((Object)ApduType.CONFIRMED_REQUEST_PDU)) ? APDUConfirmedRequest.staticParseAPDUBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)((Object)apduType), (Object)((Object)ApduType.UNCONFIRMED_REQUEST_PDU)) ? APDUUnconfirmedRequest.staticParseAPDUBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)((Object)apduType), (Object)((Object)ApduType.SIMPLE_ACK_PDU)) ? APDUSimpleAck.staticParseAPDUBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)((Object)apduType), (Object)((Object)ApduType.COMPLEX_ACK_PDU)) ? APDUComplexAck.staticParseAPDUBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)((Object)apduType), (Object)((Object)ApduType.SEGMENT_ACK_PDU)) ? APDUSegmentAck.staticParseAPDUBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)((Object)apduType), (Object)((Object)ApduType.ERROR_PDU)) ? APDUError.staticParseAPDUBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)((Object)apduType), (Object)((Object)ApduType.REJECT_PDU)) ? APDUReject.staticParseAPDUBuilder(readBuffer, apduLength) : (EvaluationHelper.equals((Object)((Object)apduType), (Object)((Object)ApduType.ABORT_PDU)) ? APDUAbort.staticParseAPDUBuilder(readBuffer, apduLength) : APDUUnknown.staticParseAPDUBuilder(readBuffer, apduLength))))))));
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [apduType=" + (Object)((Object)apduType) + "]");
        }
        readBuffer.closeContext("APDU", new WithReaderArgs[0]);
        APDU _aPDU = builder.build(apduLength);
        return _aPDU;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof APDU)) {
            return false;
        }
        APDU that = (APDU)o;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface APDUBuilder {
        public APDU build(Integer var1);
    }
}

