/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.APDU;
import org.apache.plc4x.java.bacnetip.readwrite.ApduType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceChoice;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetServiceAck;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ParseValidationException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class APDUComplexAck
extends APDU
implements Message {
    protected final boolean segmentedMessage;
    protected final boolean moreFollows;
    protected final short originalInvokeId;
    protected final Short sequenceNumber;
    protected final Short proposedWindowSize;
    protected final BACnetServiceAck serviceAck;
    protected final BACnetConfirmedServiceChoice segmentServiceChoice;
    protected final byte[] segment;
    protected final Integer apduLength;
    private Byte reservedField0;

    @Override
    public ApduType getApduType() {
        return ApduType.COMPLEX_ACK_PDU;
    }

    public APDUComplexAck(boolean segmentedMessage, boolean moreFollows, short originalInvokeId, Short sequenceNumber, Short proposedWindowSize, BACnetServiceAck serviceAck, BACnetConfirmedServiceChoice segmentServiceChoice, byte[] segment, Integer apduLength) {
        super(apduLength);
        this.segmentedMessage = segmentedMessage;
        this.moreFollows = moreFollows;
        this.originalInvokeId = originalInvokeId;
        this.sequenceNumber = sequenceNumber;
        this.proposedWindowSize = proposedWindowSize;
        this.serviceAck = serviceAck;
        this.segmentServiceChoice = segmentServiceChoice;
        this.segment = segment;
        this.apduLength = apduLength;
    }

    public boolean getSegmentedMessage() {
        return this.segmentedMessage;
    }

    public boolean getMoreFollows() {
        return this.moreFollows;
    }

    public short getOriginalInvokeId() {
        return this.originalInvokeId;
    }

    public Short getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Short getProposedWindowSize() {
        return this.proposedWindowSize;
    }

    public BACnetServiceAck getServiceAck() {
        return this.serviceAck;
    }

    public BACnetConfirmedServiceChoice getSegmentServiceChoice() {
        return this.segmentServiceChoice;
    }

    public byte[] getSegment() {
        return this.segment;
    }

    public int getApduHeaderReduction() {
        return 2 + (this.getSegmentedMessage() ? 2 : 0);
    }

    public int getSegmentReduction() {
        return this.getSegmentServiceChoice() != null ? this.getApduHeaderReduction() + 1 : this.getApduHeaderReduction();
    }

    @Override
    protected void serializeAPDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("APDUComplexAck", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"segmentedMessage", (Object)this.segmentedMessage, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"moreFollows", (Object)this.moreFollows, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)(this.reservedField0 != null ? this.reservedField0 : (byte)0), (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)2), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"originalInvokeId", (Object)this.originalInvokeId, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"sequenceNumber", (Object)this.sequenceNumber, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (boolean)this.getSegmentedMessage(), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"proposedWindowSize", (Object)this.proposedWindowSize, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (boolean)this.getSegmentedMessage(), (WithWriterArgs[])new WithWriterArgs[0]);
        int apduHeaderReduction = this.getApduHeaderReduction();
        writeBuffer.writeVirtual("apduHeaderReduction", (Object)apduHeaderReduction, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"serviceAck", (Object)this.serviceAck, (DataWriter)new DataWriterComplexDefault(writeBuffer), (!this.getSegmentedMessage() ? 1 : 0) != 0, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalEnumField((String)"segmentServiceChoice", (String)"BACnetConfirmedServiceChoice", (Object)((Object)this.segmentServiceChoice), (DataWriter)new DataWriterEnumDefault(BACnetConfirmedServiceChoice::getValue, Enum::name, DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8)), (this.getSegmentedMessage() && this.getSequenceNumber() != 0 ? 1 : 0) != 0, (WithWriterArgs[])new WithWriterArgs[0]);
        int segmentReduction = this.getSegmentReduction();
        writeBuffer.writeVirtual("segmentReduction", (Object)segmentReduction, new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"segment", (byte[])this.segment, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("APDUComplexAck", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        APDUComplexAck _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        ++lengthInBits;
        ++lengthInBits;
        lengthInBits += 2;
        lengthInBits += 8;
        if (this.sequenceNumber != null) {
            lengthInBits += 8;
        }
        if (this.proposedWindowSize != null) {
            lengthInBits += 8;
        }
        if (this.serviceAck != null) {
            lengthInBits += this.serviceAck.getLengthInBits();
        }
        if (this.segmentServiceChoice != null) {
            lengthInBits += 8;
        }
        if (this.segment != null) {
            lengthInBits += 8 * this.segment.length;
        }
        return lengthInBits;
    }

    public static APDU.APDUBuilder staticParseAPDUBuilder(ReadBuffer readBuffer, Integer apduLength) throws ParseException {
        readBuffer.pullContext("APDUComplexAck", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        boolean segmentedMessage = (Boolean)FieldReaderFactory.readSimpleField((String)"segmentedMessage", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean moreFollows = (Boolean)FieldReaderFactory.readSimpleField((String)"moreFollows", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)2), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        short originalInvokeId = (Short)FieldReaderFactory.readSimpleField((String)"originalInvokeId", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        Short sequenceNumber = (Short)FieldReaderFactory.readOptionalField((String)"sequenceNumber", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (boolean)segmentedMessage, (WithReaderArgs[])new WithReaderArgs[0]);
        Short proposedWindowSize = (Short)FieldReaderFactory.readOptionalField((String)"proposedWindowSize", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (boolean)segmentedMessage, (WithReaderArgs[])new WithReaderArgs[0]);
        int apduHeaderReduction = (Integer)FieldReaderFactory.readVirtualField((String)"apduHeaderReduction", Integer.TYPE, (Object)(2 + (segmentedMessage ? 2 : 0)), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetServiceAck serviceAck = (BACnetServiceAck)FieldReaderFactory.readOptionalField((String)"serviceAck", (DataReader)new DataReaderComplexDefault(() -> BACnetServiceAck.staticParse(readBuffer, Long.valueOf(apduLength - apduHeaderReduction)), readBuffer), (!segmentedMessage ? 1 : 0) != 0, (WithReaderArgs[])new WithReaderArgs[0]);
        if ((segmentedMessage || serviceAck == null) && !segmentedMessage) {
            throw new ParseValidationException("service ack should be set");
        }
        BACnetConfirmedServiceChoice segmentServiceChoice = (BACnetConfirmedServiceChoice)((Object)FieldReaderFactory.readOptionalField((String)"segmentServiceChoice", (DataReader)new DataReaderEnumDefault(BACnetConfirmedServiceChoice::enumForValue, DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8)), (segmentedMessage && sequenceNumber != 0 ? 1 : 0) != 0, (WithReaderArgs[])new WithReaderArgs[0]));
        int segmentReduction = (Integer)FieldReaderFactory.readVirtualField((String)"segmentReduction", Integer.TYPE, (Object)(segmentServiceChoice != null ? apduHeaderReduction + 1 : apduHeaderReduction), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] segment = readBuffer.readByteArray("segment", Math.toIntExact(segmentedMessage ? (apduLength > 0 ? apduLength - segmentReduction : 0) : 0), new WithReaderArgs[0]);
        readBuffer.closeContext("APDUComplexAck", new WithReaderArgs[0]);
        return new APDUComplexAckBuilderImpl(segmentedMessage, moreFollows, originalInvokeId, sequenceNumber, proposedWindowSize, serviceAck, segmentServiceChoice, segment, apduLength, reservedField0);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof APDUComplexAck)) {
            return false;
        }
        APDUComplexAck that = (APDUComplexAck)o;
        return this.getSegmentedMessage() == that.getSegmentedMessage() && this.getMoreFollows() == that.getMoreFollows() && this.getOriginalInvokeId() == that.getOriginalInvokeId() && this.getSequenceNumber() == that.getSequenceNumber() && this.getProposedWindowSize() == that.getProposedWindowSize() && this.getServiceAck() == that.getServiceAck() && this.getSegmentServiceChoice() == that.getSegmentServiceChoice() && this.getSegment() == that.getSegment() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getSegmentedMessage(), this.getMoreFollows(), this.getOriginalInvokeId(), this.getSequenceNumber(), this.getProposedWindowSize(), this.getServiceAck(), this.getSegmentServiceChoice(), this.getSegment()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class APDUComplexAckBuilderImpl
    implements APDU.APDUBuilder {
        private final boolean segmentedMessage;
        private final boolean moreFollows;
        private final short originalInvokeId;
        private final Short sequenceNumber;
        private final Short proposedWindowSize;
        private final BACnetServiceAck serviceAck;
        private final BACnetConfirmedServiceChoice segmentServiceChoice;
        private final byte[] segment;
        private final Integer apduLength;
        private final Byte reservedField0;

        public APDUComplexAckBuilderImpl(boolean segmentedMessage, boolean moreFollows, short originalInvokeId, Short sequenceNumber, Short proposedWindowSize, BACnetServiceAck serviceAck, BACnetConfirmedServiceChoice segmentServiceChoice, byte[] segment, Integer apduLength, Byte reservedField0) {
            this.segmentedMessage = segmentedMessage;
            this.moreFollows = moreFollows;
            this.originalInvokeId = originalInvokeId;
            this.sequenceNumber = sequenceNumber;
            this.proposedWindowSize = proposedWindowSize;
            this.serviceAck = serviceAck;
            this.segmentServiceChoice = segmentServiceChoice;
            this.segment = segment;
            this.apduLength = apduLength;
            this.reservedField0 = reservedField0;
        }

        @Override
        public APDUComplexAck build(Integer apduLength) {
            APDUComplexAck aPDUComplexAck = new APDUComplexAck(this.segmentedMessage, this.moreFollows, this.originalInvokeId, this.sequenceNumber, this.proposedWindowSize, this.serviceAck, this.segmentServiceChoice, this.segment, apduLength);
            aPDUComplexAck.reservedField0 = this.reservedField0;
            return aPDUComplexAck;
        }
    }
}

