/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.APDU;
import org.apache.plc4x.java.bacnetip.readwrite.ApduType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceChoice;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceRequest;
import org.apache.plc4x.java.bacnetip.readwrite.MaxApduLengthAccepted;
import org.apache.plc4x.java.bacnetip.readwrite.MaxSegmentsAccepted;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ParseValidationException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class APDUConfirmedRequest
extends APDU
implements Message {
    protected final boolean segmentedMessage;
    protected final boolean moreFollows;
    protected final boolean segmentedResponseAccepted;
    protected final MaxSegmentsAccepted maxSegmentsAccepted;
    protected final MaxApduLengthAccepted maxApduLengthAccepted;
    protected final short invokeId;
    protected final Short sequenceNumber;
    protected final Short proposedWindowSize;
    protected final BACnetConfirmedServiceRequest serviceRequest;
    protected final BACnetConfirmedServiceChoice segmentServiceChoice;
    protected final byte[] segment;
    protected final Integer apduLength;
    private Byte reservedField0;

    @Override
    public ApduType getApduType() {
        return ApduType.CONFIRMED_REQUEST_PDU;
    }

    public APDUConfirmedRequest(boolean segmentedMessage, boolean moreFollows, boolean segmentedResponseAccepted, MaxSegmentsAccepted maxSegmentsAccepted, MaxApduLengthAccepted maxApduLengthAccepted, short invokeId, Short sequenceNumber, Short proposedWindowSize, BACnetConfirmedServiceRequest serviceRequest, BACnetConfirmedServiceChoice segmentServiceChoice, byte[] segment, Integer apduLength) {
        super(apduLength);
        this.segmentedMessage = segmentedMessage;
        this.moreFollows = moreFollows;
        this.segmentedResponseAccepted = segmentedResponseAccepted;
        this.maxSegmentsAccepted = maxSegmentsAccepted;
        this.maxApduLengthAccepted = maxApduLengthAccepted;
        this.invokeId = invokeId;
        this.sequenceNumber = sequenceNumber;
        this.proposedWindowSize = proposedWindowSize;
        this.serviceRequest = serviceRequest;
        this.segmentServiceChoice = segmentServiceChoice;
        this.segment = segment;
        this.apduLength = apduLength;
    }

    public boolean getSegmentedMessage() {
        return this.segmentedMessage;
    }

    public boolean getMoreFollows() {
        return this.moreFollows;
    }

    public boolean getSegmentedResponseAccepted() {
        return this.segmentedResponseAccepted;
    }

    public MaxSegmentsAccepted getMaxSegmentsAccepted() {
        return this.maxSegmentsAccepted;
    }

    public MaxApduLengthAccepted getMaxApduLengthAccepted() {
        return this.maxApduLengthAccepted;
    }

    public short getInvokeId() {
        return this.invokeId;
    }

    public Short getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Short getProposedWindowSize() {
        return this.proposedWindowSize;
    }

    public BACnetConfirmedServiceRequest getServiceRequest() {
        return this.serviceRequest;
    }

    public BACnetConfirmedServiceChoice getSegmentServiceChoice() {
        return this.segmentServiceChoice;
    }

    public byte[] getSegment() {
        return this.segment;
    }

    public int getApduHeaderReduction() {
        return 3 + (this.getSegmentedMessage() ? 2 : 0);
    }

    public int getSegmentReduction() {
        return this.getSegmentServiceChoice() != null ? this.getApduHeaderReduction() + 1 : this.getApduHeaderReduction();
    }

    @Override
    protected void serializeAPDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("APDUConfirmedRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"segmentedMessage", (Object)this.segmentedMessage, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"moreFollows", (Object)this.moreFollows, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"segmentedResponseAccepted", (Object)this.segmentedResponseAccepted, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)(this.reservedField0 != null ? this.reservedField0 : (byte)0), (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)2), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"maxSegmentsAccepted", (String)"MaxSegmentsAccepted", (Object)((Object)this.maxSegmentsAccepted), (DataWriter)new DataWriterEnumDefault(MaxSegmentsAccepted::getValue, Enum::name, DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)3)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"maxApduLengthAccepted", (String)"MaxApduLengthAccepted", (Object)((Object)this.maxApduLengthAccepted), (DataWriter)new DataWriterEnumDefault(MaxApduLengthAccepted::getValue, Enum::name, DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)4)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"invokeId", (Object)this.invokeId, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"sequenceNumber", (Object)this.sequenceNumber, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (boolean)this.getSegmentedMessage(), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"proposedWindowSize", (Object)this.proposedWindowSize, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (boolean)this.getSegmentedMessage(), (WithWriterArgs[])new WithWriterArgs[0]);
        int apduHeaderReduction = this.getApduHeaderReduction();
        writeBuffer.writeVirtual("apduHeaderReduction", (Object)apduHeaderReduction, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"serviceRequest", (Object)this.serviceRequest, (DataWriter)new DataWriterComplexDefault(writeBuffer), (!this.getSegmentedMessage() ? 1 : 0) != 0, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalEnumField((String)"segmentServiceChoice", (String)"BACnetConfirmedServiceChoice", (Object)((Object)this.segmentServiceChoice), (DataWriter)new DataWriterEnumDefault(BACnetConfirmedServiceChoice::getValue, Enum::name, DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8)), (this.getSegmentedMessage() && this.getSequenceNumber() != 0 ? 1 : 0) != 0, (WithWriterArgs[])new WithWriterArgs[0]);
        int segmentReduction = this.getSegmentReduction();
        writeBuffer.writeVirtual("segmentReduction", (Object)segmentReduction, new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"segment", (byte[])this.segment, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("APDUConfirmedRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        APDUConfirmedRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        ++lengthInBits;
        ++lengthInBits;
        ++lengthInBits;
        lengthInBits += 2;
        lengthInBits += 3;
        lengthInBits += 4;
        lengthInBits += 8;
        if (this.sequenceNumber != null) {
            lengthInBits += 8;
        }
        if (this.proposedWindowSize != null) {
            lengthInBits += 8;
        }
        if (this.serviceRequest != null) {
            lengthInBits += this.serviceRequest.getLengthInBits();
        }
        if (this.segmentServiceChoice != null) {
            lengthInBits += 8;
        }
        if (this.segment != null) {
            lengthInBits += 8 * this.segment.length;
        }
        return lengthInBits;
    }

    public static APDU.APDUBuilder staticParseAPDUBuilder(ReadBuffer readBuffer, Integer apduLength) throws ParseException {
        readBuffer.pullContext("APDUConfirmedRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        boolean segmentedMessage = (Boolean)FieldReaderFactory.readSimpleField((String)"segmentedMessage", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean moreFollows = (Boolean)FieldReaderFactory.readSimpleField((String)"moreFollows", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean segmentedResponseAccepted = (Boolean)FieldReaderFactory.readSimpleField((String)"segmentedResponseAccepted", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)2), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        MaxSegmentsAccepted maxSegmentsAccepted = (MaxSegmentsAccepted)((Object)FieldReaderFactory.readEnumField((String)"maxSegmentsAccepted", (String)"MaxSegmentsAccepted", (DataReader)new DataReaderEnumDefault(MaxSegmentsAccepted::enumForValue, DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)3)), (WithReaderArgs[])new WithReaderArgs[0]));
        MaxApduLengthAccepted maxApduLengthAccepted = (MaxApduLengthAccepted)((Object)FieldReaderFactory.readEnumField((String)"maxApduLengthAccepted", (String)"MaxApduLengthAccepted", (DataReader)new DataReaderEnumDefault(MaxApduLengthAccepted::enumForValue, DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)4)), (WithReaderArgs[])new WithReaderArgs[0]));
        short invokeId = (Short)FieldReaderFactory.readSimpleField((String)"invokeId", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        Short sequenceNumber = (Short)FieldReaderFactory.readOptionalField((String)"sequenceNumber", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (boolean)segmentedMessage, (WithReaderArgs[])new WithReaderArgs[0]);
        Short proposedWindowSize = (Short)FieldReaderFactory.readOptionalField((String)"proposedWindowSize", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (boolean)segmentedMessage, (WithReaderArgs[])new WithReaderArgs[0]);
        int apduHeaderReduction = (Integer)FieldReaderFactory.readVirtualField((String)"apduHeaderReduction", Integer.TYPE, (Object)(3 + (segmentedMessage ? 2 : 0)), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetConfirmedServiceRequest serviceRequest = (BACnetConfirmedServiceRequest)FieldReaderFactory.readOptionalField((String)"serviceRequest", (DataReader)new DataReaderComplexDefault(() -> BACnetConfirmedServiceRequest.staticParse(readBuffer, Long.valueOf(apduLength - apduHeaderReduction)), readBuffer), (!segmentedMessage ? 1 : 0) != 0, (WithReaderArgs[])new WithReaderArgs[0]);
        if ((segmentedMessage || serviceRequest == null) && !segmentedMessage) {
            throw new ParseValidationException("service request should be set");
        }
        BACnetConfirmedServiceChoice segmentServiceChoice = (BACnetConfirmedServiceChoice)((Object)FieldReaderFactory.readOptionalField((String)"segmentServiceChoice", (DataReader)new DataReaderEnumDefault(BACnetConfirmedServiceChoice::enumForValue, DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8)), (segmentedMessage && sequenceNumber != 0 ? 1 : 0) != 0, (WithReaderArgs[])new WithReaderArgs[0]));
        int segmentReduction = (Integer)FieldReaderFactory.readVirtualField((String)"segmentReduction", Integer.TYPE, (Object)(segmentServiceChoice != null ? apduHeaderReduction + 1 : apduHeaderReduction), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] segment = readBuffer.readByteArray("segment", Math.toIntExact(segmentedMessage ? (apduLength > 0 ? apduLength - segmentReduction : 0) : 0), new WithReaderArgs[0]);
        readBuffer.closeContext("APDUConfirmedRequest", new WithReaderArgs[0]);
        return new APDUConfirmedRequestBuilderImpl(segmentedMessage, moreFollows, segmentedResponseAccepted, maxSegmentsAccepted, maxApduLengthAccepted, invokeId, sequenceNumber, proposedWindowSize, serviceRequest, segmentServiceChoice, segment, apduLength, reservedField0);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof APDUConfirmedRequest)) {
            return false;
        }
        APDUConfirmedRequest that = (APDUConfirmedRequest)o;
        return this.getSegmentedMessage() == that.getSegmentedMessage() && this.getMoreFollows() == that.getMoreFollows() && this.getSegmentedResponseAccepted() == that.getSegmentedResponseAccepted() && this.getMaxSegmentsAccepted() == that.getMaxSegmentsAccepted() && this.getMaxApduLengthAccepted() == that.getMaxApduLengthAccepted() && this.getInvokeId() == that.getInvokeId() && this.getSequenceNumber() == that.getSequenceNumber() && this.getProposedWindowSize() == that.getProposedWindowSize() && this.getServiceRequest() == that.getServiceRequest() && this.getSegmentServiceChoice() == that.getSegmentServiceChoice() && this.getSegment() == that.getSegment() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getSegmentedMessage(), this.getMoreFollows(), this.getSegmentedResponseAccepted(), this.getMaxSegmentsAccepted(), this.getMaxApduLengthAccepted(), this.getInvokeId(), this.getSequenceNumber(), this.getProposedWindowSize(), this.getServiceRequest(), this.getSegmentServiceChoice(), this.getSegment()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class APDUConfirmedRequestBuilderImpl
    implements APDU.APDUBuilder {
        private final boolean segmentedMessage;
        private final boolean moreFollows;
        private final boolean segmentedResponseAccepted;
        private final MaxSegmentsAccepted maxSegmentsAccepted;
        private final MaxApduLengthAccepted maxApduLengthAccepted;
        private final short invokeId;
        private final Short sequenceNumber;
        private final Short proposedWindowSize;
        private final BACnetConfirmedServiceRequest serviceRequest;
        private final BACnetConfirmedServiceChoice segmentServiceChoice;
        private final byte[] segment;
        private final Integer apduLength;
        private final Byte reservedField0;

        public APDUConfirmedRequestBuilderImpl(boolean segmentedMessage, boolean moreFollows, boolean segmentedResponseAccepted, MaxSegmentsAccepted maxSegmentsAccepted, MaxApduLengthAccepted maxApduLengthAccepted, short invokeId, Short sequenceNumber, Short proposedWindowSize, BACnetConfirmedServiceRequest serviceRequest, BACnetConfirmedServiceChoice segmentServiceChoice, byte[] segment, Integer apduLength, Byte reservedField0) {
            this.segmentedMessage = segmentedMessage;
            this.moreFollows = moreFollows;
            this.segmentedResponseAccepted = segmentedResponseAccepted;
            this.maxSegmentsAccepted = maxSegmentsAccepted;
            this.maxApduLengthAccepted = maxApduLengthAccepted;
            this.invokeId = invokeId;
            this.sequenceNumber = sequenceNumber;
            this.proposedWindowSize = proposedWindowSize;
            this.serviceRequest = serviceRequest;
            this.segmentServiceChoice = segmentServiceChoice;
            this.segment = segment;
            this.apduLength = apduLength;
            this.reservedField0 = reservedField0;
        }

        @Override
        public APDUConfirmedRequest build(Integer apduLength) {
            APDUConfirmedRequest aPDUConfirmedRequest = new APDUConfirmedRequest(this.segmentedMessage, this.moreFollows, this.segmentedResponseAccepted, this.maxSegmentsAccepted, this.maxApduLengthAccepted, this.invokeId, this.sequenceNumber, this.proposedWindowSize, this.serviceRequest, this.segmentServiceChoice, this.segment, apduLength);
            aPDUConfirmedRequest.reservedField0 = this.reservedField0;
            return aPDUConfirmedRequest;
        }
    }
}

