/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.APDU;
import org.apache.plc4x.java.bacnetip.readwrite.ApduType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class APDUSegmentAck
extends APDU
implements Message {
    protected final boolean negativeAck;
    protected final boolean server;
    protected final short originalInvokeId;
    protected final short sequenceNumber;
    protected final short actualWindowSize;
    protected final Integer apduLength;
    private Byte reservedField0;

    @Override
    public ApduType getApduType() {
        return ApduType.SEGMENT_ACK_PDU;
    }

    public APDUSegmentAck(boolean negativeAck, boolean server, short originalInvokeId, short sequenceNumber, short actualWindowSize, Integer apduLength) {
        super(apduLength);
        this.negativeAck = negativeAck;
        this.server = server;
        this.originalInvokeId = originalInvokeId;
        this.sequenceNumber = sequenceNumber;
        this.actualWindowSize = actualWindowSize;
        this.apduLength = apduLength;
    }

    public boolean getNegativeAck() {
        return this.negativeAck;
    }

    public boolean getServer() {
        return this.server;
    }

    public short getOriginalInvokeId() {
        return this.originalInvokeId;
    }

    public short getSequenceNumber() {
        return this.sequenceNumber;
    }

    public short getActualWindowSize() {
        return this.actualWindowSize;
    }

    @Override
    protected void serializeAPDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("APDUSegmentAck", new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)(this.reservedField0 != null ? this.reservedField0 : (byte)0), (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)2), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"negativeAck", (Object)this.negativeAck, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"server", (Object)this.server, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"originalInvokeId", (Object)this.originalInvokeId, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"sequenceNumber", (Object)this.sequenceNumber, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"actualWindowSize", (Object)this.actualWindowSize, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("APDUSegmentAck", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        APDUSegmentAck _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 2;
        ++lengthInBits;
        ++lengthInBits;
        lengthInBits += 8;
        lengthInBits += 8;
        return lengthInBits += 8;
    }

    public static APDU.APDUBuilder staticParseAPDUBuilder(ReadBuffer readBuffer, Integer apduLength) throws ParseException {
        readBuffer.pullContext("APDUSegmentAck", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)2), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean negativeAck = (Boolean)FieldReaderFactory.readSimpleField((String)"negativeAck", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean server = (Boolean)FieldReaderFactory.readSimpleField((String)"server", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        short originalInvokeId = (Short)FieldReaderFactory.readSimpleField((String)"originalInvokeId", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        short sequenceNumber = (Short)FieldReaderFactory.readSimpleField((String)"sequenceNumber", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        short actualWindowSize = (Short)FieldReaderFactory.readSimpleField((String)"actualWindowSize", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("APDUSegmentAck", new WithReaderArgs[0]);
        return new APDUSegmentAckBuilderImpl(negativeAck, server, originalInvokeId, sequenceNumber, actualWindowSize, apduLength, reservedField0);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof APDUSegmentAck)) {
            return false;
        }
        APDUSegmentAck that = (APDUSegmentAck)o;
        return this.getNegativeAck() == that.getNegativeAck() && this.getServer() == that.getServer() && this.getOriginalInvokeId() == that.getOriginalInvokeId() && this.getSequenceNumber() == that.getSequenceNumber() && this.getActualWindowSize() == that.getActualWindowSize() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNegativeAck(), this.getServer(), this.getOriginalInvokeId(), this.getSequenceNumber(), this.getActualWindowSize());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class APDUSegmentAckBuilderImpl
    implements APDU.APDUBuilder {
        private final boolean negativeAck;
        private final boolean server;
        private final short originalInvokeId;
        private final short sequenceNumber;
        private final short actualWindowSize;
        private final Integer apduLength;
        private final Byte reservedField0;

        public APDUSegmentAckBuilderImpl(boolean negativeAck, boolean server, short originalInvokeId, short sequenceNumber, short actualWindowSize, Integer apduLength, Byte reservedField0) {
            this.negativeAck = negativeAck;
            this.server = server;
            this.originalInvokeId = originalInvokeId;
            this.sequenceNumber = sequenceNumber;
            this.actualWindowSize = actualWindowSize;
            this.apduLength = apduLength;
            this.reservedField0 = reservedField0;
        }

        @Override
        public APDUSegmentAck build(Integer apduLength) {
            APDUSegmentAck aPDUSegmentAck = new APDUSegmentAck(this.negativeAck, this.server, this.originalInvokeId, this.sequenceNumber, this.actualWindowSize, apduLength);
            aPDUSegmentAck.reservedField0 = this.reservedField0;
            return aPDUSegmentAck;
        }
    }
}

