/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.APDU;
import org.apache.plc4x.java.bacnetip.readwrite.ApduType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetUnconfirmedServiceRequest;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class APDUUnconfirmedRequest
extends APDU
implements Message {
    protected final BACnetUnconfirmedServiceRequest serviceRequest;
    protected final Integer apduLength;
    private Byte reservedField0;

    @Override
    public ApduType getApduType() {
        return ApduType.UNCONFIRMED_REQUEST_PDU;
    }

    public APDUUnconfirmedRequest(BACnetUnconfirmedServiceRequest serviceRequest, Integer apduLength) {
        super(apduLength);
        this.serviceRequest = serviceRequest;
        this.apduLength = apduLength;
    }

    public BACnetUnconfirmedServiceRequest getServiceRequest() {
        return this.serviceRequest;
    }

    @Override
    protected void serializeAPDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("APDUUnconfirmedRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)(this.reservedField0 != null ? this.reservedField0 : (byte)0), (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)4), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"serviceRequest", (Object)this.serviceRequest, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("APDUUnconfirmedRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        APDUUnconfirmedRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 4;
        return lengthInBits += this.serviceRequest.getLengthInBits();
    }

    public static APDU.APDUBuilder staticParseAPDUBuilder(ReadBuffer readBuffer, Integer apduLength) throws ParseException {
        readBuffer.pullContext("APDUUnconfirmedRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)4), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetUnconfirmedServiceRequest serviceRequest = (BACnetUnconfirmedServiceRequest)FieldReaderFactory.readSimpleField((String)"serviceRequest", (DataReader)new DataReaderComplexDefault(() -> BACnetUnconfirmedServiceRequest.staticParse(readBuffer, apduLength - 1), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("APDUUnconfirmedRequest", new WithReaderArgs[0]);
        return new APDUUnconfirmedRequestBuilderImpl(serviceRequest, apduLength, reservedField0);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof APDUUnconfirmedRequest)) {
            return false;
        }
        APDUUnconfirmedRequest that = (APDUUnconfirmedRequest)o;
        return this.getServiceRequest() == that.getServiceRequest() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getServiceRequest());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class APDUUnconfirmedRequestBuilderImpl
    implements APDU.APDUBuilder {
        private final BACnetUnconfirmedServiceRequest serviceRequest;
        private final Integer apduLength;
        private final Byte reservedField0;

        public APDUUnconfirmedRequestBuilderImpl(BACnetUnconfirmedServiceRequest serviceRequest, Integer apduLength, Byte reservedField0) {
            this.serviceRequest = serviceRequest;
            this.apduLength = apduLength;
            this.reservedField0 = reservedField0;
        }

        @Override
        public APDUUnconfirmedRequest build(Integer apduLength) {
            APDUUnconfirmedRequest aPDUUnconfirmedRequest = new APDUUnconfirmedRequest(this.serviceRequest, apduLength);
            aPDUUnconfirmedRequest.reservedField0 = this.reservedField0;
            return aPDUUnconfirmedRequest;
        }
    }
}

