/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.APDU;
import org.apache.plc4x.java.bacnetip.readwrite.ApduType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class APDUUnknown
extends APDU
implements Message {
    protected final byte unknownTypeRest;
    protected final byte[] unknownBytes;
    protected final Integer apduLength;

    @Override
    public ApduType getApduType() {
        return null;
    }

    public APDUUnknown(byte unknownTypeRest, byte[] unknownBytes, Integer apduLength) {
        super(apduLength);
        this.unknownTypeRest = unknownTypeRest;
        this.unknownBytes = unknownBytes;
        this.apduLength = apduLength;
    }

    public byte getUnknownTypeRest() {
        return this.unknownTypeRest;
    }

    public byte[] getUnknownBytes() {
        return this.unknownBytes;
    }

    @Override
    protected void serializeAPDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("APDUUnknown", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"unknownTypeRest", (Object)this.unknownTypeRest, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)4), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"unknownBytes", (byte[])this.unknownBytes, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("APDUUnknown", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        APDUUnknown _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 4;
        if (this.unknownBytes != null) {
            lengthInBits += 8 * this.unknownBytes.length;
        }
        return lengthInBits;
    }

    public static APDU.APDUBuilder staticParseAPDUBuilder(ReadBuffer readBuffer, Integer apduLength) throws ParseException {
        readBuffer.pullContext("APDUUnknown", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        byte unknownTypeRest = (Byte)FieldReaderFactory.readSimpleField((String)"unknownTypeRest", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)4), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] unknownBytes = readBuffer.readByteArray("unknownBytes", Math.toIntExact(apduLength > 0 ? apduLength : 0), new WithReaderArgs[0]);
        readBuffer.closeContext("APDUUnknown", new WithReaderArgs[0]);
        return new APDUUnknownBuilderImpl(unknownTypeRest, unknownBytes, apduLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof APDUUnknown)) {
            return false;
        }
        APDUUnknown that = (APDUUnknown)o;
        return this.getUnknownTypeRest() == that.getUnknownTypeRest() && this.getUnknownBytes() == that.getUnknownBytes() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getUnknownTypeRest(), this.getUnknownBytes());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class APDUUnknownBuilderImpl
    implements APDU.APDUBuilder {
        private final byte unknownTypeRest;
        private final byte[] unknownBytes;
        private final Integer apduLength;

        public APDUUnknownBuilderImpl(byte unknownTypeRest, byte[] unknownBytes, Integer apduLength) {
            this.unknownTypeRest = unknownTypeRest;
            this.unknownBytes = unknownBytes;
            this.apduLength = apduLength;
        }

        @Override
        public APDUUnknown build(Integer apduLength) {
            APDUUnknown aPDUUnknown = new APDUUnknown(this.unknownTypeRest, this.unknownBytes, apduLength);
            return aPDUUnknown;
        }
    }
}

