/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetAbortReason;
import org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetAbortReasonTagged
implements Message {
    protected final BACnetAbortReason value;
    protected final long proprietaryValue;
    protected final Long actualLength;

    public BACnetAbortReasonTagged(BACnetAbortReason value, long proprietaryValue, Long actualLength) {
        this.value = value;
        this.proprietaryValue = proprietaryValue;
        this.actualLength = actualLength;
    }

    public BACnetAbortReason getValue() {
        return this.value;
    }

    public long getProprietaryValue() {
        return this.proprietaryValue;
    }

    public boolean getIsProprietary() {
        return this.getValue() == BACnetAbortReason.VENDOR_PROPRIETARY_VALUE;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetAbortReasonTagged", new WithWriterArgs[0]);
        FieldWriterFactory.writeManualField((String)"value", () -> StaticHelper.writeEnumGeneric(writeBuffer, this.value), (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        boolean isProprietary = this.getIsProprietary();
        writeBuffer.writeVirtual("isProprietary", (Object)isProprietary, new WithWriterArgs[0]);
        FieldWriterFactory.writeManualField((String)"proprietaryValue", () -> StaticHelper.writeProprietaryEnumGeneric(writeBuffer, this.proprietaryValue, isProprietary), (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetAbortReasonTagged", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetAbortReasonTagged _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits = (int)((long)lengthInBits + (_value.getIsProprietary() ? 0L : this.actualLength * 8L));
        lengthInBits = (int)((long)lengthInBits + (_value.getIsProprietary() ? this.actualLength * 8L : 0L));
        return lengthInBits;
    }

    public static BACnetAbortReasonTagged staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Long actualLength;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Long) {
            actualLength = (Long)args[0];
        } else if (args[0] instanceof String) {
            actualLength = Long.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Long or a string which is parseable but was " + args[0].getClass().getName());
        }
        return BACnetAbortReasonTagged.staticParse(readBuffer, actualLength);
    }

    public static BACnetAbortReasonTagged staticParse(ReadBuffer readBuffer, Long actualLength) throws ParseException {
        readBuffer.pullContext("BACnetAbortReasonTagged", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetAbortReason value = (BACnetAbortReason)((Object)FieldReaderFactory.readManualField((String)"value", (ReadBuffer)readBuffer, () -> (BACnetAbortReason)((Object)((Object)StaticHelper.readEnumGeneric(readBuffer, actualLength, BACnetAbortReason.VENDOR_PROPRIETARY_VALUE))), (WithReaderArgs[])new WithReaderArgs[0]));
        boolean isProprietary = (Boolean)FieldReaderFactory.readVirtualField((String)"isProprietary", Boolean.TYPE, (Object)(value == BACnetAbortReason.VENDOR_PROPRIETARY_VALUE ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        long proprietaryValue = (Long)FieldReaderFactory.readManualField((String)"proprietaryValue", (ReadBuffer)readBuffer, () -> StaticHelper.readProprietaryEnumGeneric(readBuffer, actualLength, isProprietary), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetAbortReasonTagged", new WithReaderArgs[0]);
        BACnetAbortReasonTagged _bACnetAbortReasonTagged = new BACnetAbortReasonTagged(value, proprietaryValue, actualLength);
        return _bACnetAbortReasonTagged;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetAbortReasonTagged)) {
            return false;
        }
        BACnetAbortReasonTagged that = (BACnetAbortReasonTagged)o;
        return this.getValue() == that.getValue() && this.getProprietaryValue() == that.getProprietaryValue();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getValue(), this.getProprietaryValue()});
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

