/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.math.BigInteger;
import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagOctetString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagUnsignedInteger;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetAddress
implements Message {
    protected final BACnetApplicationTagUnsignedInteger networkNumber;
    protected final BACnetApplicationTagOctetString macAddress;

    public BACnetAddress(BACnetApplicationTagUnsignedInteger networkNumber, BACnetApplicationTagOctetString macAddress) {
        this.networkNumber = networkNumber;
        this.macAddress = macAddress;
    }

    public BACnetApplicationTagUnsignedInteger getNetworkNumber() {
        return this.networkNumber;
    }

    public BACnetApplicationTagOctetString getMacAddress() {
        return this.macAddress;
    }

    public BigInteger getZero() {
        Long o = 0L;
        if (o instanceof BigInteger) {
            return (BigInteger)((Object)o);
        }
        return BigInteger.valueOf(((Number)o).longValue());
    }

    public boolean getIsLocalNetwork() {
        return this.getNetworkNumber().getActualValue() == this.getZero();
    }

    public boolean getIsBroadcast() {
        return this.getMacAddress().getActualLength() == 0L;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetAddress", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"networkNumber", (Object)this.networkNumber, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        BigInteger zero = this.getZero();
        writeBuffer.writeVirtual("zero", (Object)zero, new WithWriterArgs[0]);
        boolean isLocalNetwork = this.getIsLocalNetwork();
        writeBuffer.writeVirtual("isLocalNetwork", (Object)isLocalNetwork, new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"macAddress", (Object)this.macAddress, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        boolean isBroadcast = this.getIsBroadcast();
        writeBuffer.writeVirtual("isBroadcast", (Object)isBroadcast, new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetAddress", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetAddress _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.networkNumber.getLengthInBits();
        return lengthInBits += this.macAddress.getLengthInBits();
    }

    public static BACnetAddress staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return BACnetAddress.staticParse(readBuffer);
    }

    public static BACnetAddress staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("BACnetAddress", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetApplicationTagUnsignedInteger networkNumber = (BACnetApplicationTagUnsignedInteger)FieldReaderFactory.readSimpleField((String)"networkNumber", (DataReader)new DataReaderComplexDefault(() -> (BACnetApplicationTagUnsignedInteger)BACnetApplicationTag.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BigInteger zero = (BigInteger)FieldReaderFactory.readVirtualField((String)"zero", BigInteger.class, (Object)0L, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isLocalNetwork = (Boolean)FieldReaderFactory.readVirtualField((String)"isLocalNetwork", Boolean.TYPE, (Object)(networkNumber.getActualValue() == zero ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetApplicationTagOctetString macAddress = (BACnetApplicationTagOctetString)FieldReaderFactory.readSimpleField((String)"macAddress", (DataReader)new DataReaderComplexDefault(() -> (BACnetApplicationTagOctetString)BACnetApplicationTag.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isBroadcast = (Boolean)FieldReaderFactory.readVirtualField((String)"isBroadcast", Boolean.TYPE, (Object)(macAddress.getActualLength() == 0L ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetAddress", new WithReaderArgs[0]);
        BACnetAddress _bACnetAddress = new BACnetAddress(networkNumber, macAddress);
        return _bACnetAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetAddress)) {
            return false;
        }
        BACnetAddress that = (BACnetAddress)o;
        return this.getNetworkNumber() == that.getNetworkNumber() && this.getMacAddress() == that.getMacAddress();
    }

    public int hashCode() {
        return Objects.hash(this.getNetworkNumber(), this.getMacAddress());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

