/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagBitString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagBoolean;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagCharacterString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagDate;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagDouble;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagEnumerated;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagNull;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagObjectIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagOctetString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagReal;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagSignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagTime;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ParseValidationException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class BACnetApplicationTag
implements Message {
    protected final BACnetTagHeader header;

    public BACnetApplicationTag(BACnetTagHeader header) {
        this.header = header;
    }

    public BACnetTagHeader getHeader() {
        return this.header;
    }

    public short getActualTagNumber() {
        return this.getHeader().getActualTagNumber();
    }

    public long getActualLength() {
        return this.getHeader().getActualLength();
    }

    protected abstract void serializeBACnetApplicationTagChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetApplicationTag", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"header", (Object)this.header, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        short actualTagNumber = this.getActualTagNumber();
        writeBuffer.writeVirtual("actualTagNumber", (Object)actualTagNumber, new WithWriterArgs[0]);
        long actualLength = this.getActualLength();
        writeBuffer.writeVirtual("actualLength", (Object)actualLength, new WithWriterArgs[0]);
        this.serializeBACnetApplicationTagChild(writeBuffer);
        writeBuffer.popContext("BACnetApplicationTag", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetApplicationTag _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits += this.header.getLengthInBits();
    }

    public static BACnetApplicationTag staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return BACnetApplicationTag.staticParse(readBuffer);
    }

    public static BACnetApplicationTag staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("BACnetApplicationTag", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetTagHeader header = (BACnetTagHeader)FieldReaderFactory.readSimpleField((String)"header", (DataReader)new DataReaderComplexDefault(() -> BACnetTagHeader.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        if (header.getTagClass() != TagClass.APPLICATION_TAGS) {
            throw new ParseValidationException("should be a application tag");
        }
        short actualTagNumber = (Short)FieldReaderFactory.readVirtualField((String)"actualTagNumber", Short.TYPE, (Object)header.getActualTagNumber(), (WithReaderArgs[])new WithReaderArgs[0]);
        long actualLength = (Long)FieldReaderFactory.readVirtualField((String)"actualLength", Long.TYPE, (Object)header.getActualLength(), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetApplicationTagBuilder builder = null;
        if (EvaluationHelper.equals((Object)actualTagNumber, (Object)0)) {
            builder = BACnetApplicationTagNull.staticParseBACnetApplicationTagBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)actualTagNumber, (Object)1)) {
            builder = BACnetApplicationTagBoolean.staticParseBACnetApplicationTagBuilder(readBuffer, header);
        } else if (EvaluationHelper.equals((Object)actualTagNumber, (Object)2)) {
            builder = BACnetApplicationTagUnsignedInteger.staticParseBACnetApplicationTagBuilder(readBuffer, header);
        } else if (EvaluationHelper.equals((Object)actualTagNumber, (Object)3)) {
            builder = BACnetApplicationTagSignedInteger.staticParseBACnetApplicationTagBuilder(readBuffer, header);
        } else if (EvaluationHelper.equals((Object)actualTagNumber, (Object)4)) {
            builder = BACnetApplicationTagReal.staticParseBACnetApplicationTagBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)actualTagNumber, (Object)5)) {
            builder = BACnetApplicationTagDouble.staticParseBACnetApplicationTagBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)actualTagNumber, (Object)6)) {
            builder = BACnetApplicationTagOctetString.staticParseBACnetApplicationTagBuilder(readBuffer, header);
        } else if (EvaluationHelper.equals((Object)actualTagNumber, (Object)7)) {
            builder = BACnetApplicationTagCharacterString.staticParseBACnetApplicationTagBuilder(readBuffer, header);
        } else if (EvaluationHelper.equals((Object)actualTagNumber, (Object)8)) {
            builder = BACnetApplicationTagBitString.staticParseBACnetApplicationTagBuilder(readBuffer, header);
        } else if (EvaluationHelper.equals((Object)actualTagNumber, (Object)9)) {
            builder = BACnetApplicationTagEnumerated.staticParseBACnetApplicationTagBuilder(readBuffer, header);
        } else if (EvaluationHelper.equals((Object)actualTagNumber, (Object)10)) {
            builder = BACnetApplicationTagDate.staticParseBACnetApplicationTagBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)actualTagNumber, (Object)11)) {
            builder = BACnetApplicationTagTime.staticParseBACnetApplicationTagBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)actualTagNumber, (Object)12)) {
            builder = BACnetApplicationTagObjectIdentifier.staticParseBACnetApplicationTagBuilder(readBuffer);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [actualTagNumber=" + actualTagNumber + "]");
        }
        readBuffer.closeContext("BACnetApplicationTag", new WithReaderArgs[0]);
        BACnetApplicationTag _bACnetApplicationTag = builder.build(header);
        return _bACnetApplicationTag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetApplicationTag)) {
            return false;
        }
        BACnetApplicationTag that = (BACnetApplicationTag)o;
        return this.getHeader() == that.getHeader();
    }

    public int hashCode() {
        return Objects.hash(this.getHeader());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface BACnetApplicationTagBuilder {
        public BACnetApplicationTag build(BACnetTagHeader var1);
    }
}

