/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagOctetString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDataType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetHostNPortEnclosed;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetBDTEntry
implements Message {
    protected final BACnetHostNPortEnclosed bbmdAddress;
    protected final BACnetContextTagOctetString broadcastMask;

    public BACnetBDTEntry(BACnetHostNPortEnclosed bbmdAddress, BACnetContextTagOctetString broadcastMask) {
        this.bbmdAddress = bbmdAddress;
        this.broadcastMask = broadcastMask;
    }

    public BACnetHostNPortEnclosed getBbmdAddress() {
        return this.bbmdAddress;
    }

    public BACnetContextTagOctetString getBroadcastMask() {
        return this.broadcastMask;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetBDTEntry", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"bbmdAddress", (Object)this.bbmdAddress, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"broadcastMask", (Object)this.broadcastMask, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetBDTEntry", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetBDTEntry _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.bbmdAddress.getLengthInBits();
        if (this.broadcastMask != null) {
            lengthInBits += this.broadcastMask.getLengthInBits();
        }
        return lengthInBits;
    }

    public static BACnetBDTEntry staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return BACnetBDTEntry.staticParse(readBuffer);
    }

    public static BACnetBDTEntry staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("BACnetBDTEntry", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetHostNPortEnclosed bbmdAddress = (BACnetHostNPortEnclosed)FieldReaderFactory.readSimpleField((String)"bbmdAddress", (DataReader)new DataReaderComplexDefault(() -> BACnetHostNPortEnclosed.staticParse(readBuffer, (short)0), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetContextTagOctetString broadcastMask = (BACnetContextTagOctetString)FieldReaderFactory.readOptionalField((String)"broadcastMask", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagOctetString)BACnetContextTag.staticParse(readBuffer, (short)1, BACnetDataType.OCTET_STRING), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetBDTEntry", new WithReaderArgs[0]);
        BACnetBDTEntry _bACnetBDTEntry = new BACnetBDTEntry(bbmdAddress, broadcastMask);
        return _bACnetBDTEntry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetBDTEntry)) {
            return false;
        }
        BACnetBDTEntry that = (BACnetBDTEntry)o;
        return this.getBbmdAddress() == that.getBbmdAddress() && this.getBroadcastMask() == that.getBroadcastMask();
    }

    public int hashCode() {
        return Objects.hash(this.getBbmdAddress(), this.getBroadcastMask());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

