/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseAssertException;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ParseValidationException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetClosingTag
implements Message {
    protected final BACnetTagHeader header;
    protected final Short tagNumberArgument;

    public BACnetClosingTag(BACnetTagHeader header, Short tagNumberArgument) {
        this.header = header;
        this.tagNumberArgument = tagNumberArgument;
    }

    public BACnetTagHeader getHeader() {
        return this.header;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetClosingTag", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"header", (Object)this.header, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetClosingTag", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetClosingTag _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits += this.header.getLengthInBits();
    }

    public static BACnetClosingTag staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Short tagNumberArgument;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Short) {
            tagNumberArgument = (Short)args[0];
        } else if (args[0] instanceof String) {
            tagNumberArgument = Short.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Short or a string which is parseable but was " + args[0].getClass().getName());
        }
        return BACnetClosingTag.staticParse(readBuffer, tagNumberArgument);
    }

    public static BACnetClosingTag staticParse(ReadBuffer readBuffer, Short tagNumberArgument) throws ParseException {
        readBuffer.pullContext("BACnetClosingTag", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetTagHeader header = (BACnetTagHeader)FieldReaderFactory.readSimpleField((String)"header", (DataReader)new DataReaderComplexDefault(() -> BACnetTagHeader.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        if (header.getActualTagNumber() != tagNumberArgument.shortValue()) {
            throw new ParseAssertException("tagnumber doesn't match");
        }
        if (header.getTagClass() != TagClass.CONTEXT_SPECIFIC_TAGS) {
            throw new ParseValidationException("should be a context tag");
        }
        if (header.getLengthValueType() != 7) {
            throw new ParseValidationException("closing tag should have a value of 7");
        }
        readBuffer.closeContext("BACnetClosingTag", new WithReaderArgs[0]);
        BACnetClosingTag _bACnetClosingTag = new BACnetClosingTag(header, tagNumberArgument);
        return _bACnetClosingTag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetClosingTag)) {
            return false;
        }
        BACnetClosingTag that = (BACnetClosingTag)o;
        return this.getHeader() == that.getHeader();
    }

    public int hashCode() {
        return Objects.hash(this.getHeader());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

