/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagObjectIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceChoice;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceRequest;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetConfirmedServiceRequestAtomicReadFile
extends BACnetConfirmedServiceRequest
implements Message {
    protected final BACnetApplicationTagObjectIdentifier fileIdentifier;
    protected final BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord accessMethod;
    protected final Long serviceRequestLength;

    @Override
    public BACnetConfirmedServiceChoice getServiceChoice() {
        return BACnetConfirmedServiceChoice.ATOMIC_READ_FILE;
    }

    public BACnetConfirmedServiceRequestAtomicReadFile(BACnetApplicationTagObjectIdentifier fileIdentifier, BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord accessMethod, Long serviceRequestLength) {
        super(serviceRequestLength);
        this.fileIdentifier = fileIdentifier;
        this.accessMethod = accessMethod;
        this.serviceRequestLength = serviceRequestLength;
    }

    public BACnetApplicationTagObjectIdentifier getFileIdentifier() {
        return this.fileIdentifier;
    }

    public BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord getAccessMethod() {
        return this.accessMethod;
    }

    @Override
    protected void serializeBACnetConfirmedServiceRequestChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetConfirmedServiceRequestAtomicReadFile", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"fileIdentifier", (Object)this.fileIdentifier, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"accessMethod", (Object)this.accessMethod, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetConfirmedServiceRequestAtomicReadFile", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetConfirmedServiceRequestAtomicReadFile _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.fileIdentifier.getLengthInBits();
        return lengthInBits += this.accessMethod.getLengthInBits();
    }

    public static BACnetConfirmedServiceRequest.BACnetConfirmedServiceRequestBuilder staticParseBACnetConfirmedServiceRequestBuilder(ReadBuffer readBuffer, Long serviceRequestLength) throws ParseException {
        readBuffer.pullContext("BACnetConfirmedServiceRequestAtomicReadFile", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetApplicationTagObjectIdentifier fileIdentifier = (BACnetApplicationTagObjectIdentifier)FieldReaderFactory.readSimpleField((String)"fileIdentifier", (DataReader)new DataReaderComplexDefault(() -> (BACnetApplicationTagObjectIdentifier)BACnetApplicationTag.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord accessMethod = (BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord)FieldReaderFactory.readSimpleField((String)"accessMethod", (DataReader)new DataReaderComplexDefault(() -> BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetConfirmedServiceRequestAtomicReadFile", new WithReaderArgs[0]);
        return new BACnetConfirmedServiceRequestAtomicReadFileBuilderImpl(fileIdentifier, accessMethod, serviceRequestLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetConfirmedServiceRequestAtomicReadFile)) {
            return false;
        }
        BACnetConfirmedServiceRequestAtomicReadFile that = (BACnetConfirmedServiceRequestAtomicReadFile)o;
        return this.getFileIdentifier() == that.getFileIdentifier() && this.getAccessMethod() == that.getAccessMethod() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getFileIdentifier(), this.getAccessMethod());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetConfirmedServiceRequestAtomicReadFileBuilderImpl
    implements BACnetConfirmedServiceRequest.BACnetConfirmedServiceRequestBuilder {
        private final BACnetApplicationTagObjectIdentifier fileIdentifier;
        private final BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord accessMethod;
        private final Long serviceRequestLength;

        public BACnetConfirmedServiceRequestAtomicReadFileBuilderImpl(BACnetApplicationTagObjectIdentifier fileIdentifier, BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord accessMethod, Long serviceRequestLength) {
            this.fileIdentifier = fileIdentifier;
            this.accessMethod = accessMethod;
            this.serviceRequestLength = serviceRequestLength;
        }

        @Override
        public BACnetConfirmedServiceRequestAtomicReadFile build(Long serviceRequestLength) {
            BACnetConfirmedServiceRequestAtomicReadFile bACnetConfirmedServiceRequestAtomicReadFile = new BACnetConfirmedServiceRequestAtomicReadFile(this.fileIdentifier, this.accessMethod, serviceRequestLength);
            return bACnetConfirmedServiceRequestAtomicReadFile;
        }
    }
}

