/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagObjectIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagOctetString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagSignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetClosingTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceChoice;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceRequest;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetOpeningTag;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetConfirmedServiceRequestAtomicWriteFile
extends BACnetConfirmedServiceRequest
implements Message {
    protected final BACnetApplicationTagObjectIdentifier deviceIdentifier;
    protected final BACnetOpeningTag openingTag;
    protected final BACnetApplicationTagSignedInteger fileStartPosition;
    protected final BACnetApplicationTagOctetString fileData;
    protected final BACnetClosingTag closingTag;
    protected final Long serviceRequestLength;

    @Override
    public BACnetConfirmedServiceChoice getServiceChoice() {
        return BACnetConfirmedServiceChoice.ATOMIC_WRITE_FILE;
    }

    public BACnetConfirmedServiceRequestAtomicWriteFile(BACnetApplicationTagObjectIdentifier deviceIdentifier, BACnetOpeningTag openingTag, BACnetApplicationTagSignedInteger fileStartPosition, BACnetApplicationTagOctetString fileData, BACnetClosingTag closingTag, Long serviceRequestLength) {
        super(serviceRequestLength);
        this.deviceIdentifier = deviceIdentifier;
        this.openingTag = openingTag;
        this.fileStartPosition = fileStartPosition;
        this.fileData = fileData;
        this.closingTag = closingTag;
        this.serviceRequestLength = serviceRequestLength;
    }

    public BACnetApplicationTagObjectIdentifier getDeviceIdentifier() {
        return this.deviceIdentifier;
    }

    public BACnetOpeningTag getOpeningTag() {
        return this.openingTag;
    }

    public BACnetApplicationTagSignedInteger getFileStartPosition() {
        return this.fileStartPosition;
    }

    public BACnetApplicationTagOctetString getFileData() {
        return this.fileData;
    }

    public BACnetClosingTag getClosingTag() {
        return this.closingTag;
    }

    @Override
    protected void serializeBACnetConfirmedServiceRequestChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetConfirmedServiceRequestAtomicWriteFile", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"deviceIdentifier", (Object)this.deviceIdentifier, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"openingTag", (Object)this.openingTag, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"fileStartPosition", (Object)this.fileStartPosition, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"fileData", (Object)this.fileData, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"closingTag", (Object)this.closingTag, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetConfirmedServiceRequestAtomicWriteFile", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetConfirmedServiceRequestAtomicWriteFile _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.deviceIdentifier.getLengthInBits();
        if (this.openingTag != null) {
            lengthInBits += this.openingTag.getLengthInBits();
        }
        lengthInBits += this.fileStartPosition.getLengthInBits();
        lengthInBits += this.fileData.getLengthInBits();
        if (this.closingTag != null) {
            lengthInBits += this.closingTag.getLengthInBits();
        }
        return lengthInBits;
    }

    public static BACnetConfirmedServiceRequest.BACnetConfirmedServiceRequestBuilder staticParseBACnetConfirmedServiceRequestBuilder(ReadBuffer readBuffer, Long serviceRequestLength) throws ParseException {
        readBuffer.pullContext("BACnetConfirmedServiceRequestAtomicWriteFile", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetApplicationTagObjectIdentifier deviceIdentifier = (BACnetApplicationTagObjectIdentifier)FieldReaderFactory.readSimpleField((String)"deviceIdentifier", (DataReader)new DataReaderComplexDefault(() -> (BACnetApplicationTagObjectIdentifier)BACnetApplicationTag.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetOpeningTag openingTag = (BACnetOpeningTag)FieldReaderFactory.readOptionalField((String)"openingTag", (DataReader)new DataReaderComplexDefault(() -> BACnetOpeningTag.staticParse(readBuffer, (short)0), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetApplicationTagSignedInteger fileStartPosition = (BACnetApplicationTagSignedInteger)FieldReaderFactory.readSimpleField((String)"fileStartPosition", (DataReader)new DataReaderComplexDefault(() -> (BACnetApplicationTagSignedInteger)BACnetApplicationTag.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetApplicationTagOctetString fileData = (BACnetApplicationTagOctetString)FieldReaderFactory.readSimpleField((String)"fileData", (DataReader)new DataReaderComplexDefault(() -> (BACnetApplicationTagOctetString)BACnetApplicationTag.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetClosingTag closingTag = (BACnetClosingTag)FieldReaderFactory.readOptionalField((String)"closingTag", (DataReader)new DataReaderComplexDefault(() -> BACnetClosingTag.staticParse(readBuffer, (short)0), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetConfirmedServiceRequestAtomicWriteFile", new WithReaderArgs[0]);
        return new BACnetConfirmedServiceRequestAtomicWriteFileBuilderImpl(deviceIdentifier, openingTag, fileStartPosition, fileData, closingTag, serviceRequestLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetConfirmedServiceRequestAtomicWriteFile)) {
            return false;
        }
        BACnetConfirmedServiceRequestAtomicWriteFile that = (BACnetConfirmedServiceRequestAtomicWriteFile)o;
        return this.getDeviceIdentifier() == that.getDeviceIdentifier() && this.getOpeningTag() == that.getOpeningTag() && this.getFileStartPosition() == that.getFileStartPosition() && this.getFileData() == that.getFileData() && this.getClosingTag() == that.getClosingTag() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDeviceIdentifier(), this.getOpeningTag(), this.getFileStartPosition(), this.getFileData(), this.getClosingTag());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetConfirmedServiceRequestAtomicWriteFileBuilderImpl
    implements BACnetConfirmedServiceRequest.BACnetConfirmedServiceRequestBuilder {
        private final BACnetApplicationTagObjectIdentifier deviceIdentifier;
        private final BACnetOpeningTag openingTag;
        private final BACnetApplicationTagSignedInteger fileStartPosition;
        private final BACnetApplicationTagOctetString fileData;
        private final BACnetClosingTag closingTag;
        private final Long serviceRequestLength;

        public BACnetConfirmedServiceRequestAtomicWriteFileBuilderImpl(BACnetApplicationTagObjectIdentifier deviceIdentifier, BACnetOpeningTag openingTag, BACnetApplicationTagSignedInteger fileStartPosition, BACnetApplicationTagOctetString fileData, BACnetClosingTag closingTag, Long serviceRequestLength) {
            this.deviceIdentifier = deviceIdentifier;
            this.openingTag = openingTag;
            this.fileStartPosition = fileStartPosition;
            this.fileData = fileData;
            this.closingTag = closingTag;
            this.serviceRequestLength = serviceRequestLength;
        }

        @Override
        public BACnetConfirmedServiceRequestAtomicWriteFile build(Long serviceRequestLength) {
            BACnetConfirmedServiceRequestAtomicWriteFile bACnetConfirmedServiceRequestAtomicWriteFile = new BACnetConfirmedServiceRequestAtomicWriteFile(this.deviceIdentifier, this.openingTag, this.fileStartPosition, this.fileData, this.closingTag, serviceRequestLength);
            return bACnetConfirmedServiceRequestAtomicWriteFile;
        }
    }
}

