/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceChoice;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceRequest;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagCharacterString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagObjectIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDataType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetLifeSafetyOperationTagged;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetConfirmedServiceRequestLifeSafetyOperation
extends BACnetConfirmedServiceRequest
implements Message {
    protected final BACnetContextTagUnsignedInteger requestingProcessIdentifier;
    protected final BACnetContextTagCharacterString requestingSource;
    protected final BACnetLifeSafetyOperationTagged request;
    protected final BACnetContextTagObjectIdentifier objectIdentifier;
    protected final Long serviceRequestLength;

    @Override
    public BACnetConfirmedServiceChoice getServiceChoice() {
        return BACnetConfirmedServiceChoice.LIFE_SAFETY_OPERATION;
    }

    public BACnetConfirmedServiceRequestLifeSafetyOperation(BACnetContextTagUnsignedInteger requestingProcessIdentifier, BACnetContextTagCharacterString requestingSource, BACnetLifeSafetyOperationTagged request, BACnetContextTagObjectIdentifier objectIdentifier, Long serviceRequestLength) {
        super(serviceRequestLength);
        this.requestingProcessIdentifier = requestingProcessIdentifier;
        this.requestingSource = requestingSource;
        this.request = request;
        this.objectIdentifier = objectIdentifier;
        this.serviceRequestLength = serviceRequestLength;
    }

    public BACnetContextTagUnsignedInteger getRequestingProcessIdentifier() {
        return this.requestingProcessIdentifier;
    }

    public BACnetContextTagCharacterString getRequestingSource() {
        return this.requestingSource;
    }

    public BACnetLifeSafetyOperationTagged getRequest() {
        return this.request;
    }

    public BACnetContextTagObjectIdentifier getObjectIdentifier() {
        return this.objectIdentifier;
    }

    @Override
    protected void serializeBACnetConfirmedServiceRequestChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetConfirmedServiceRequestLifeSafetyOperation", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestingProcessIdentifier", (Object)this.requestingProcessIdentifier, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestingSource", (Object)this.requestingSource, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"request", (Object)this.request, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"objectIdentifier", (Object)this.objectIdentifier, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetConfirmedServiceRequestLifeSafetyOperation", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetConfirmedServiceRequestLifeSafetyOperation _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestingProcessIdentifier.getLengthInBits();
        lengthInBits += this.requestingSource.getLengthInBits();
        lengthInBits += this.request.getLengthInBits();
        if (this.objectIdentifier != null) {
            lengthInBits += this.objectIdentifier.getLengthInBits();
        }
        return lengthInBits;
    }

    public static BACnetConfirmedServiceRequest.BACnetConfirmedServiceRequestBuilder staticParseBACnetConfirmedServiceRequestBuilder(ReadBuffer readBuffer, Long serviceRequestLength) throws ParseException {
        readBuffer.pullContext("BACnetConfirmedServiceRequestLifeSafetyOperation", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetContextTagUnsignedInteger requestingProcessIdentifier = (BACnetContextTagUnsignedInteger)FieldReaderFactory.readSimpleField((String)"requestingProcessIdentifier", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagUnsignedInteger)BACnetContextTag.staticParse(readBuffer, (short)0, BACnetDataType.UNSIGNED_INTEGER), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetContextTagCharacterString requestingSource = (BACnetContextTagCharacterString)FieldReaderFactory.readSimpleField((String)"requestingSource", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagCharacterString)BACnetContextTag.staticParse(readBuffer, (short)1, BACnetDataType.CHARACTER_STRING), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetLifeSafetyOperationTagged request = (BACnetLifeSafetyOperationTagged)FieldReaderFactory.readSimpleField((String)"request", (DataReader)new DataReaderComplexDefault(() -> BACnetLifeSafetyOperationTagged.staticParse(readBuffer, (short)2, TagClass.CONTEXT_SPECIFIC_TAGS), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetContextTagObjectIdentifier objectIdentifier = (BACnetContextTagObjectIdentifier)FieldReaderFactory.readOptionalField((String)"objectIdentifier", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagObjectIdentifier)BACnetContextTag.staticParse(readBuffer, (short)3, BACnetDataType.BACNET_OBJECT_IDENTIFIER), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetConfirmedServiceRequestLifeSafetyOperation", new WithReaderArgs[0]);
        return new BACnetConfirmedServiceRequestLifeSafetyOperationBuilderImpl(requestingProcessIdentifier, requestingSource, request, objectIdentifier, serviceRequestLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetConfirmedServiceRequestLifeSafetyOperation)) {
            return false;
        }
        BACnetConfirmedServiceRequestLifeSafetyOperation that = (BACnetConfirmedServiceRequestLifeSafetyOperation)o;
        return this.getRequestingProcessIdentifier() == that.getRequestingProcessIdentifier() && this.getRequestingSource() == that.getRequestingSource() && this.getRequest() == that.getRequest() && this.getObjectIdentifier() == that.getObjectIdentifier() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestingProcessIdentifier(), this.getRequestingSource(), this.getRequest(), this.getObjectIdentifier());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetConfirmedServiceRequestLifeSafetyOperationBuilderImpl
    implements BACnetConfirmedServiceRequest.BACnetConfirmedServiceRequestBuilder {
        private final BACnetContextTagUnsignedInteger requestingProcessIdentifier;
        private final BACnetContextTagCharacterString requestingSource;
        private final BACnetLifeSafetyOperationTagged request;
        private final BACnetContextTagObjectIdentifier objectIdentifier;
        private final Long serviceRequestLength;

        public BACnetConfirmedServiceRequestLifeSafetyOperationBuilderImpl(BACnetContextTagUnsignedInteger requestingProcessIdentifier, BACnetContextTagCharacterString requestingSource, BACnetLifeSafetyOperationTagged request, BACnetContextTagObjectIdentifier objectIdentifier, Long serviceRequestLength) {
            this.requestingProcessIdentifier = requestingProcessIdentifier;
            this.requestingSource = requestingSource;
            this.request = request;
            this.objectIdentifier = objectIdentifier;
            this.serviceRequestLength = serviceRequestLength;
        }

        @Override
        public BACnetConfirmedServiceRequestLifeSafetyOperation build(Long serviceRequestLength) {
            BACnetConfirmedServiceRequestLifeSafetyOperation bACnetConfirmedServiceRequestLifeSafetyOperation = new BACnetConfirmedServiceRequestLifeSafetyOperation(this.requestingProcessIdentifier, this.requestingSource, this.request, this.objectIdentifier, serviceRequestLength);
            return bACnetConfirmedServiceRequestLifeSafetyOperation;
        }
    }
}

