/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceChoice;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceRequest;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagObjectIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDataType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPropertyIdentifierTagged;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetConfirmedServiceRequestReadProperty
extends BACnetConfirmedServiceRequest
implements Message {
    protected final BACnetContextTagObjectIdentifier objectIdentifier;
    protected final BACnetPropertyIdentifierTagged propertyIdentifier;
    protected final BACnetContextTagUnsignedInteger arrayIndex;
    protected final Long serviceRequestLength;

    @Override
    public BACnetConfirmedServiceChoice getServiceChoice() {
        return BACnetConfirmedServiceChoice.READ_PROPERTY;
    }

    public BACnetConfirmedServiceRequestReadProperty(BACnetContextTagObjectIdentifier objectIdentifier, BACnetPropertyIdentifierTagged propertyIdentifier, BACnetContextTagUnsignedInteger arrayIndex, Long serviceRequestLength) {
        super(serviceRequestLength);
        this.objectIdentifier = objectIdentifier;
        this.propertyIdentifier = propertyIdentifier;
        this.arrayIndex = arrayIndex;
        this.serviceRequestLength = serviceRequestLength;
    }

    public BACnetContextTagObjectIdentifier getObjectIdentifier() {
        return this.objectIdentifier;
    }

    public BACnetPropertyIdentifierTagged getPropertyIdentifier() {
        return this.propertyIdentifier;
    }

    public BACnetContextTagUnsignedInteger getArrayIndex() {
        return this.arrayIndex;
    }

    @Override
    protected void serializeBACnetConfirmedServiceRequestChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetConfirmedServiceRequestReadProperty", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"objectIdentifier", (Object)this.objectIdentifier, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"propertyIdentifier", (Object)this.propertyIdentifier, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"arrayIndex", (Object)this.arrayIndex, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetConfirmedServiceRequestReadProperty", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetConfirmedServiceRequestReadProperty _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.objectIdentifier.getLengthInBits();
        lengthInBits += this.propertyIdentifier.getLengthInBits();
        if (this.arrayIndex != null) {
            lengthInBits += this.arrayIndex.getLengthInBits();
        }
        return lengthInBits;
    }

    public static BACnetConfirmedServiceRequest.BACnetConfirmedServiceRequestBuilder staticParseBACnetConfirmedServiceRequestBuilder(ReadBuffer readBuffer, Long serviceRequestLength) throws ParseException {
        readBuffer.pullContext("BACnetConfirmedServiceRequestReadProperty", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetContextTagObjectIdentifier objectIdentifier = (BACnetContextTagObjectIdentifier)FieldReaderFactory.readSimpleField((String)"objectIdentifier", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagObjectIdentifier)BACnetContextTag.staticParse(readBuffer, (short)0, BACnetDataType.BACNET_OBJECT_IDENTIFIER), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetPropertyIdentifierTagged propertyIdentifier = (BACnetPropertyIdentifierTagged)FieldReaderFactory.readSimpleField((String)"propertyIdentifier", (DataReader)new DataReaderComplexDefault(() -> BACnetPropertyIdentifierTagged.staticParse(readBuffer, (short)1, TagClass.CONTEXT_SPECIFIC_TAGS), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetContextTagUnsignedInteger arrayIndex = (BACnetContextTagUnsignedInteger)FieldReaderFactory.readOptionalField((String)"arrayIndex", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagUnsignedInteger)BACnetContextTag.staticParse(readBuffer, (short)2, BACnetDataType.UNSIGNED_INTEGER), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetConfirmedServiceRequestReadProperty", new WithReaderArgs[0]);
        return new BACnetConfirmedServiceRequestReadPropertyBuilderImpl(objectIdentifier, propertyIdentifier, arrayIndex, serviceRequestLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetConfirmedServiceRequestReadProperty)) {
            return false;
        }
        BACnetConfirmedServiceRequestReadProperty that = (BACnetConfirmedServiceRequestReadProperty)o;
        return this.getObjectIdentifier() == that.getObjectIdentifier() && this.getPropertyIdentifier() == that.getPropertyIdentifier() && this.getArrayIndex() == that.getArrayIndex() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getObjectIdentifier(), this.getPropertyIdentifier(), this.getArrayIndex());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetConfirmedServiceRequestReadPropertyBuilderImpl
    implements BACnetConfirmedServiceRequest.BACnetConfirmedServiceRequestBuilder {
        private final BACnetContextTagObjectIdentifier objectIdentifier;
        private final BACnetPropertyIdentifierTagged propertyIdentifier;
        private final BACnetContextTagUnsignedInteger arrayIndex;
        private final Long serviceRequestLength;

        public BACnetConfirmedServiceRequestReadPropertyBuilderImpl(BACnetContextTagObjectIdentifier objectIdentifier, BACnetPropertyIdentifierTagged propertyIdentifier, BACnetContextTagUnsignedInteger arrayIndex, Long serviceRequestLength) {
            this.objectIdentifier = objectIdentifier;
            this.propertyIdentifier = propertyIdentifier;
            this.arrayIndex = arrayIndex;
            this.serviceRequestLength = serviceRequestLength;
        }

        @Override
        public BACnetConfirmedServiceRequestReadProperty build(Long serviceRequestLength) {
            BACnetConfirmedServiceRequestReadProperty bACnetConfirmedServiceRequestReadProperty = new BACnetConfirmedServiceRequestReadProperty(this.objectIdentifier, this.propertyIdentifier, this.arrayIndex, serviceRequestLength);
            return bACnetConfirmedServiceRequestReadProperty;
        }
    }
}

