/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceChoice;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConfirmedServiceRequest;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetConfirmedServiceRequestRequestKey
extends BACnetConfirmedServiceRequest
implements Message {
    protected final byte[] bytesOfRemovedService;
    protected final Long serviceRequestPayloadLength;
    protected final Long serviceRequestLength;

    @Override
    public BACnetConfirmedServiceChoice getServiceChoice() {
        return BACnetConfirmedServiceChoice.REQUEST_KEY;
    }

    public BACnetConfirmedServiceRequestRequestKey(byte[] bytesOfRemovedService, Long serviceRequestPayloadLength, Long serviceRequestLength) {
        super(serviceRequestLength);
        this.bytesOfRemovedService = bytesOfRemovedService;
        this.serviceRequestPayloadLength = serviceRequestPayloadLength;
        this.serviceRequestLength = serviceRequestLength;
    }

    public byte[] getBytesOfRemovedService() {
        return this.bytesOfRemovedService;
    }

    @Override
    protected void serializeBACnetConfirmedServiceRequestChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetConfirmedServiceRequestRequestKey", new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"bytesOfRemovedService", (byte[])this.bytesOfRemovedService, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetConfirmedServiceRequestRequestKey", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetConfirmedServiceRequestRequestKey _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.bytesOfRemovedService != null) {
            lengthInBits += 8 * this.bytesOfRemovedService.length;
        }
        return lengthInBits;
    }

    public static BACnetConfirmedServiceRequest.BACnetConfirmedServiceRequestBuilder staticParseBACnetConfirmedServiceRequestBuilder(ReadBuffer readBuffer, Long serviceRequestPayloadLength, Long serviceRequestLength) throws ParseException {
        readBuffer.pullContext("BACnetConfirmedServiceRequestRequestKey", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        byte[] bytesOfRemovedService = readBuffer.readByteArray("bytesOfRemovedService", Math.toIntExact(serviceRequestPayloadLength), new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetConfirmedServiceRequestRequestKey", new WithReaderArgs[0]);
        return new BACnetConfirmedServiceRequestRequestKeyBuilderImpl(bytesOfRemovedService, serviceRequestPayloadLength, serviceRequestLength);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetConfirmedServiceRequestRequestKey)) {
            return false;
        }
        BACnetConfirmedServiceRequestRequestKey that = (BACnetConfirmedServiceRequestRequestKey)o;
        return this.getBytesOfRemovedService() == that.getBytesOfRemovedService() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getBytesOfRemovedService());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetConfirmedServiceRequestRequestKeyBuilderImpl
    implements BACnetConfirmedServiceRequest.BACnetConfirmedServiceRequestBuilder {
        private final byte[] bytesOfRemovedService;
        private final Long serviceRequestPayloadLength;
        private final Long serviceRequestLength;

        public BACnetConfirmedServiceRequestRequestKeyBuilderImpl(byte[] bytesOfRemovedService, Long serviceRequestPayloadLength, Long serviceRequestLength) {
            this.bytesOfRemovedService = bytesOfRemovedService;
            this.serviceRequestPayloadLength = serviceRequestPayloadLength;
            this.serviceRequestLength = serviceRequestLength;
        }

        @Override
        public BACnetConfirmedServiceRequestRequestKey build(Long serviceRequestLength) {
            BACnetConfirmedServiceRequestRequestKey bACnetConfirmedServiceRequestRequestKey = new BACnetConfirmedServiceRequestRequestKey(this.bytesOfRemovedService, this.serviceRequestPayloadLength, serviceRequestLength);
            return bACnetConfirmedServiceRequestRequestKey;
        }
    }
}

