/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetClosingTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConstructedData;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetObjectType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetOpeningTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetOptionalCharacterString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPropertyIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ParseValidationException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetConstructedDataEventMessageTexts
extends BACnetConstructedData
implements Message {
    protected final BACnetApplicationTagUnsignedInteger numberOfDataElements;
    protected final List<BACnetOptionalCharacterString> eventMessageTexts;
    protected final Short tagNumber;
    protected final BACnetTagPayloadUnsignedInteger arrayIndexArgument;

    @Override
    public BACnetObjectType getObjectTypeArgument() {
        return null;
    }

    @Override
    public BACnetPropertyIdentifier getPropertyIdentifierArgument() {
        return BACnetPropertyIdentifier.EVENT_MESSAGE_TEXTS;
    }

    public BACnetConstructedDataEventMessageTexts(BACnetOpeningTag openingTag, BACnetTagHeader peekedTagHeader, BACnetClosingTag closingTag, BACnetApplicationTagUnsignedInteger numberOfDataElements, List<BACnetOptionalCharacterString> eventMessageTexts, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
        super(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument);
        this.numberOfDataElements = numberOfDataElements;
        this.eventMessageTexts = eventMessageTexts;
        this.tagNumber = tagNumber;
        this.arrayIndexArgument = arrayIndexArgument;
    }

    public BACnetApplicationTagUnsignedInteger getNumberOfDataElements() {
        return this.numberOfDataElements;
    }

    public List<BACnetOptionalCharacterString> getEventMessageTexts() {
        return this.eventMessageTexts;
    }

    public BigInteger getZero() {
        Long o = 0L;
        if (o instanceof BigInteger) {
            return (BigInteger)((Object)o);
        }
        return BigInteger.valueOf(((Number)o).longValue());
    }

    public BACnetOptionalCharacterString getToOffnormalText() {
        return org.apache.plc4x.java.spi.generation.StaticHelper.COUNT(this.getEventMessageTexts()) == 3 ? this.getEventMessageTexts().get(0) : null;
    }

    public BACnetOptionalCharacterString getToFaultText() {
        return org.apache.plc4x.java.spi.generation.StaticHelper.COUNT(this.getEventMessageTexts()) == 3 ? this.getEventMessageTexts().get(1) : null;
    }

    public BACnetOptionalCharacterString getToNormalText() {
        return org.apache.plc4x.java.spi.generation.StaticHelper.COUNT(this.getEventMessageTexts()) == 3 ? this.getEventMessageTexts().get(2) : null;
    }

    @Override
    protected void serializeBACnetConstructedDataChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetConstructedDataEventMessageTexts", new WithWriterArgs[0]);
        BigInteger zero = this.getZero();
        writeBuffer.writeVirtual("zero", (Object)zero, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"numberOfDataElements", (Object)this.numberOfDataElements, (DataWriter)new DataWriterComplexDefault(writeBuffer), (this.arrayIndexArgument != null && this.arrayIndexArgument.getActualValue() == this.getZero() ? 1 : 0) != 0, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"eventMessageTexts", this.eventMessageTexts, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        BACnetOptionalCharacterString toOffnormalText = this.getToOffnormalText();
        writeBuffer.writeVirtual("toOffnormalText", (Object)toOffnormalText, new WithWriterArgs[0]);
        BACnetOptionalCharacterString toFaultText = this.getToFaultText();
        writeBuffer.writeVirtual("toFaultText", (Object)toFaultText, new WithWriterArgs[0]);
        BACnetOptionalCharacterString toNormalText = this.getToNormalText();
        writeBuffer.writeVirtual("toNormalText", (Object)toNormalText, new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetConstructedDataEventMessageTexts", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetConstructedDataEventMessageTexts _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.numberOfDataElements != null) {
            lengthInBits += this.numberOfDataElements.getLengthInBits();
        }
        if (this.eventMessageTexts != null) {
            for (Message message : this.eventMessageTexts) {
                lengthInBits += message.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static BACnetConstructedData.BACnetConstructedDataBuilder staticParseBACnetConstructedDataBuilder(ReadBuffer readBuffer, Short tagNumber, BACnetObjectType objectTypeArgument, BACnetPropertyIdentifier propertyIdentifierArgument, BACnetTagPayloadUnsignedInteger arrayIndexArgument) throws ParseException {
        readBuffer.pullContext("BACnetConstructedDataEventMessageTexts", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BigInteger zero = (BigInteger)FieldReaderFactory.readVirtualField((String)"zero", BigInteger.class, (Object)0L, (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetApplicationTagUnsignedInteger numberOfDataElements = (BACnetApplicationTagUnsignedInteger)FieldReaderFactory.readOptionalField((String)"numberOfDataElements", (DataReader)new DataReaderComplexDefault(() -> (BACnetApplicationTagUnsignedInteger)BACnetApplicationTag.staticParse(readBuffer), readBuffer), (arrayIndexArgument != null && arrayIndexArgument.getActualValue() == zero ? 1 : 0) != 0, (WithReaderArgs[])new WithReaderArgs[0]);
        List eventMessageTexts = FieldReaderFactory.readTerminatedArrayField((String)"eventMessageTexts", (DataReader)new DataReaderComplexDefault(() -> BACnetOptionalCharacterString.staticParse(readBuffer), readBuffer), () -> StaticHelper.isBACnetConstructedDataClosingTag(readBuffer, false, tagNumber.shortValue()), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetOptionalCharacterString toOffnormalText = (BACnetOptionalCharacterString)FieldReaderFactory.readVirtualField((String)"toOffnormalText", BACnetOptionalCharacterString.class, org.apache.plc4x.java.spi.generation.StaticHelper.COUNT((Object)eventMessageTexts) == 3 ? eventMessageTexts.get(0) : null, (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetOptionalCharacterString toFaultText = (BACnetOptionalCharacterString)FieldReaderFactory.readVirtualField((String)"toFaultText", BACnetOptionalCharacterString.class, org.apache.plc4x.java.spi.generation.StaticHelper.COUNT((Object)eventMessageTexts) == 3 ? eventMessageTexts.get(1) : null, (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetOptionalCharacterString toNormalText = (BACnetOptionalCharacterString)FieldReaderFactory.readVirtualField((String)"toNormalText", BACnetOptionalCharacterString.class, org.apache.plc4x.java.spi.generation.StaticHelper.COUNT((Object)eventMessageTexts) == 3 ? eventMessageTexts.get(2) : null, (WithReaderArgs[])new WithReaderArgs[0]);
        if (arrayIndexArgument == null && org.apache.plc4x.java.spi.generation.StaticHelper.COUNT((Object)eventMessageTexts) != 3) {
            throw new ParseValidationException("eventMessageTexts should have exactly 3 values");
        }
        readBuffer.closeContext("BACnetConstructedDataEventMessageTexts", new WithReaderArgs[0]);
        return new BACnetConstructedDataEventMessageTextsBuilderImpl(numberOfDataElements, eventMessageTexts, tagNumber, arrayIndexArgument);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetConstructedDataEventMessageTexts)) {
            return false;
        }
        BACnetConstructedDataEventMessageTexts that = (BACnetConstructedDataEventMessageTexts)o;
        return this.getNumberOfDataElements() == that.getNumberOfDataElements() && this.getEventMessageTexts() == that.getEventMessageTexts() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNumberOfDataElements(), this.getEventMessageTexts());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetConstructedDataEventMessageTextsBuilderImpl
    implements BACnetConstructedData.BACnetConstructedDataBuilder {
        private final BACnetApplicationTagUnsignedInteger numberOfDataElements;
        private final List<BACnetOptionalCharacterString> eventMessageTexts;
        private final Short tagNumber;
        private final BACnetTagPayloadUnsignedInteger arrayIndexArgument;

        public BACnetConstructedDataEventMessageTextsBuilderImpl(BACnetApplicationTagUnsignedInteger numberOfDataElements, List<BACnetOptionalCharacterString> eventMessageTexts, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
            this.numberOfDataElements = numberOfDataElements;
            this.eventMessageTexts = eventMessageTexts;
            this.tagNumber = tagNumber;
            this.arrayIndexArgument = arrayIndexArgument;
        }

        @Override
        public BACnetConstructedDataEventMessageTexts build(BACnetOpeningTag openingTag, BACnetTagHeader peekedTagHeader, BACnetClosingTag closingTag, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
            BACnetConstructedDataEventMessageTexts bACnetConstructedDataEventMessageTexts = new BACnetConstructedDataEventMessageTexts(openingTag, peekedTagHeader, closingTag, this.numberOfDataElements, this.eventMessageTexts, tagNumber, arrayIndexArgument);
            return bACnetConstructedDataEventMessageTexts;
        }
    }
}

