/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetClosingTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConstructedData;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetObjectType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetOpeningTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPropertyIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTimeStamp;
import org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ParseValidationException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetConstructedDataEventTimeStamps
extends BACnetConstructedData
implements Message {
    protected final BACnetApplicationTagUnsignedInteger numberOfDataElements;
    protected final List<BACnetTimeStamp> eventTimeStamps;
    protected final Short tagNumber;
    protected final BACnetTagPayloadUnsignedInteger arrayIndexArgument;

    @Override
    public BACnetObjectType getObjectTypeArgument() {
        return null;
    }

    @Override
    public BACnetPropertyIdentifier getPropertyIdentifierArgument() {
        return BACnetPropertyIdentifier.EVENT_TIME_STAMPS;
    }

    public BACnetConstructedDataEventTimeStamps(BACnetOpeningTag openingTag, BACnetTagHeader peekedTagHeader, BACnetClosingTag closingTag, BACnetApplicationTagUnsignedInteger numberOfDataElements, List<BACnetTimeStamp> eventTimeStamps, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
        super(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument);
        this.numberOfDataElements = numberOfDataElements;
        this.eventTimeStamps = eventTimeStamps;
        this.tagNumber = tagNumber;
        this.arrayIndexArgument = arrayIndexArgument;
    }

    public BACnetApplicationTagUnsignedInteger getNumberOfDataElements() {
        return this.numberOfDataElements;
    }

    public List<BACnetTimeStamp> getEventTimeStamps() {
        return this.eventTimeStamps;
    }

    public BigInteger getZero() {
        Long o = 0L;
        if (o instanceof BigInteger) {
            return (BigInteger)((Object)o);
        }
        return BigInteger.valueOf(((Number)o).longValue());
    }

    public BACnetTimeStamp getToOffnormal() {
        return org.apache.plc4x.java.spi.generation.StaticHelper.COUNT(this.getEventTimeStamps()) == 3 ? this.getEventTimeStamps().get(0) : null;
    }

    public BACnetTimeStamp getToFault() {
        return org.apache.plc4x.java.spi.generation.StaticHelper.COUNT(this.getEventTimeStamps()) == 3 ? this.getEventTimeStamps().get(1) : null;
    }

    public BACnetTimeStamp getToNormal() {
        return org.apache.plc4x.java.spi.generation.StaticHelper.COUNT(this.getEventTimeStamps()) == 3 ? this.getEventTimeStamps().get(2) : null;
    }

    @Override
    protected void serializeBACnetConstructedDataChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetConstructedDataEventTimeStamps", new WithWriterArgs[0]);
        BigInteger zero = this.getZero();
        writeBuffer.writeVirtual("zero", (Object)zero, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"numberOfDataElements", (Object)this.numberOfDataElements, (DataWriter)new DataWriterComplexDefault(writeBuffer), (this.arrayIndexArgument != null && this.arrayIndexArgument.getActualValue() == this.getZero() ? 1 : 0) != 0, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"eventTimeStamps", this.eventTimeStamps, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        BACnetTimeStamp toOffnormal = this.getToOffnormal();
        writeBuffer.writeVirtual("toOffnormal", (Object)toOffnormal, new WithWriterArgs[0]);
        BACnetTimeStamp toFault = this.getToFault();
        writeBuffer.writeVirtual("toFault", (Object)toFault, new WithWriterArgs[0]);
        BACnetTimeStamp toNormal = this.getToNormal();
        writeBuffer.writeVirtual("toNormal", (Object)toNormal, new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetConstructedDataEventTimeStamps", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetConstructedDataEventTimeStamps _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.numberOfDataElements != null) {
            lengthInBits += this.numberOfDataElements.getLengthInBits();
        }
        if (this.eventTimeStamps != null) {
            for (Message message : this.eventTimeStamps) {
                lengthInBits += message.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static BACnetConstructedData.BACnetConstructedDataBuilder staticParseBACnetConstructedDataBuilder(ReadBuffer readBuffer, Short tagNumber, BACnetObjectType objectTypeArgument, BACnetPropertyIdentifier propertyIdentifierArgument, BACnetTagPayloadUnsignedInteger arrayIndexArgument) throws ParseException {
        readBuffer.pullContext("BACnetConstructedDataEventTimeStamps", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BigInteger zero = (BigInteger)FieldReaderFactory.readVirtualField((String)"zero", BigInteger.class, (Object)0L, (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetApplicationTagUnsignedInteger numberOfDataElements = (BACnetApplicationTagUnsignedInteger)FieldReaderFactory.readOptionalField((String)"numberOfDataElements", (DataReader)new DataReaderComplexDefault(() -> (BACnetApplicationTagUnsignedInteger)BACnetApplicationTag.staticParse(readBuffer), readBuffer), (arrayIndexArgument != null && arrayIndexArgument.getActualValue() == zero ? 1 : 0) != 0, (WithReaderArgs[])new WithReaderArgs[0]);
        List eventTimeStamps = FieldReaderFactory.readTerminatedArrayField((String)"eventTimeStamps", (DataReader)new DataReaderComplexDefault(() -> BACnetTimeStamp.staticParse(readBuffer), readBuffer), () -> StaticHelper.isBACnetConstructedDataClosingTag(readBuffer, false, tagNumber.shortValue()), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetTimeStamp toOffnormal = (BACnetTimeStamp)FieldReaderFactory.readVirtualField((String)"toOffnormal", BACnetTimeStamp.class, org.apache.plc4x.java.spi.generation.StaticHelper.COUNT((Object)eventTimeStamps) == 3 ? eventTimeStamps.get(0) : null, (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetTimeStamp toFault = (BACnetTimeStamp)FieldReaderFactory.readVirtualField((String)"toFault", BACnetTimeStamp.class, org.apache.plc4x.java.spi.generation.StaticHelper.COUNT((Object)eventTimeStamps) == 3 ? eventTimeStamps.get(1) : null, (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetTimeStamp toNormal = (BACnetTimeStamp)FieldReaderFactory.readVirtualField((String)"toNormal", BACnetTimeStamp.class, org.apache.plc4x.java.spi.generation.StaticHelper.COUNT((Object)eventTimeStamps) == 3 ? eventTimeStamps.get(2) : null, (WithReaderArgs[])new WithReaderArgs[0]);
        if (arrayIndexArgument == null && org.apache.plc4x.java.spi.generation.StaticHelper.COUNT((Object)eventTimeStamps) != 3) {
            throw new ParseValidationException("eventTimeStamps should have exactly 3 values");
        }
        readBuffer.closeContext("BACnetConstructedDataEventTimeStamps", new WithReaderArgs[0]);
        return new BACnetConstructedDataEventTimeStampsBuilderImpl(numberOfDataElements, eventTimeStamps, tagNumber, arrayIndexArgument);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetConstructedDataEventTimeStamps)) {
            return false;
        }
        BACnetConstructedDataEventTimeStamps that = (BACnetConstructedDataEventTimeStamps)o;
        return this.getNumberOfDataElements() == that.getNumberOfDataElements() && this.getEventTimeStamps() == that.getEventTimeStamps() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNumberOfDataElements(), this.getEventTimeStamps());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetConstructedDataEventTimeStampsBuilderImpl
    implements BACnetConstructedData.BACnetConstructedDataBuilder {
        private final BACnetApplicationTagUnsignedInteger numberOfDataElements;
        private final List<BACnetTimeStamp> eventTimeStamps;
        private final Short tagNumber;
        private final BACnetTagPayloadUnsignedInteger arrayIndexArgument;

        public BACnetConstructedDataEventTimeStampsBuilderImpl(BACnetApplicationTagUnsignedInteger numberOfDataElements, List<BACnetTimeStamp> eventTimeStamps, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
            this.numberOfDataElements = numberOfDataElements;
            this.eventTimeStamps = eventTimeStamps;
            this.tagNumber = tagNumber;
            this.arrayIndexArgument = arrayIndexArgument;
        }

        @Override
        public BACnetConstructedDataEventTimeStamps build(BACnetOpeningTag openingTag, BACnetTagHeader peekedTagHeader, BACnetClosingTag closingTag, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
            BACnetConstructedDataEventTimeStamps bACnetConstructedDataEventTimeStamps = new BACnetConstructedDataEventTimeStamps(openingTag, peekedTagHeader, closingTag, this.numberOfDataElements, this.eventTimeStamps, tagNumber, arrayIndexArgument);
            return bACnetConstructedDataEventTimeStamps;
        }
    }
}

