/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagCharacterString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetClosingTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConstructedData;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetObjectType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetOpeningTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPropertyIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadUnsignedInteger;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetConstructedDataProgramLocation
extends BACnetConstructedData
implements Message {
    protected final BACnetApplicationTagCharacterString programLocation;
    protected final Short tagNumber;
    protected final BACnetTagPayloadUnsignedInteger arrayIndexArgument;

    @Override
    public BACnetObjectType getObjectTypeArgument() {
        return null;
    }

    @Override
    public BACnetPropertyIdentifier getPropertyIdentifierArgument() {
        return BACnetPropertyIdentifier.PROGRAM_LOCATION;
    }

    public BACnetConstructedDataProgramLocation(BACnetOpeningTag openingTag, BACnetTagHeader peekedTagHeader, BACnetClosingTag closingTag, BACnetApplicationTagCharacterString programLocation, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
        super(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument);
        this.programLocation = programLocation;
        this.tagNumber = tagNumber;
        this.arrayIndexArgument = arrayIndexArgument;
    }

    public BACnetApplicationTagCharacterString getProgramLocation() {
        return this.programLocation;
    }

    public BACnetApplicationTagCharacterString getActualValue() {
        return this.getProgramLocation();
    }

    @Override
    protected void serializeBACnetConstructedDataChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetConstructedDataProgramLocation", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"programLocation", (Object)this.programLocation, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        BACnetApplicationTagCharacterString actualValue = this.getActualValue();
        writeBuffer.writeVirtual("actualValue", (Object)actualValue, new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetConstructedDataProgramLocation", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetConstructedDataProgramLocation _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits += this.programLocation.getLengthInBits();
    }

    public static BACnetConstructedData.BACnetConstructedDataBuilder staticParseBACnetConstructedDataBuilder(ReadBuffer readBuffer, Short tagNumber, BACnetObjectType objectTypeArgument, BACnetPropertyIdentifier propertyIdentifierArgument, BACnetTagPayloadUnsignedInteger arrayIndexArgument) throws ParseException {
        readBuffer.pullContext("BACnetConstructedDataProgramLocation", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetApplicationTagCharacterString programLocation = (BACnetApplicationTagCharacterString)FieldReaderFactory.readSimpleField((String)"programLocation", (DataReader)new DataReaderComplexDefault(() -> (BACnetApplicationTagCharacterString)BACnetApplicationTag.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetApplicationTagCharacterString actualValue = (BACnetApplicationTagCharacterString)FieldReaderFactory.readVirtualField((String)"actualValue", BACnetApplicationTagCharacterString.class, (Object)programLocation, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetConstructedDataProgramLocation", new WithReaderArgs[0]);
        return new BACnetConstructedDataProgramLocationBuilderImpl(programLocation, tagNumber, arrayIndexArgument);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetConstructedDataProgramLocation)) {
            return false;
        }
        BACnetConstructedDataProgramLocation that = (BACnetConstructedDataProgramLocation)o;
        return this.getProgramLocation() == that.getProgramLocation() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getProgramLocation());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetConstructedDataProgramLocationBuilderImpl
    implements BACnetConstructedData.BACnetConstructedDataBuilder {
        private final BACnetApplicationTagCharacterString programLocation;
        private final Short tagNumber;
        private final BACnetTagPayloadUnsignedInteger arrayIndexArgument;

        public BACnetConstructedDataProgramLocationBuilderImpl(BACnetApplicationTagCharacterString programLocation, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
            this.programLocation = programLocation;
            this.tagNumber = tagNumber;
            this.arrayIndexArgument = arrayIndexArgument;
        }

        @Override
        public BACnetConstructedDataProgramLocation build(BACnetOpeningTag openingTag, BACnetTagHeader peekedTagHeader, BACnetClosingTag closingTag, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
            BACnetConstructedDataProgramLocation bACnetConstructedDataProgramLocation = new BACnetConstructedDataProgramLocation(openingTag, peekedTagHeader, closingTag, this.programLocation, tagNumber, arrayIndexArgument);
            return bACnetConstructedDataProgramLocation;
        }
    }
}

