/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagCharacterString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetClosingTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConstructedData;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetObjectType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetOpeningTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPropertyIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadUnsignedInteger;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetConstructedDataSerialNumber
extends BACnetConstructedData
implements Message {
    protected final BACnetApplicationTagCharacterString serialNumber;
    protected final Short tagNumber;
    protected final BACnetTagPayloadUnsignedInteger arrayIndexArgument;

    @Override
    public BACnetObjectType getObjectTypeArgument() {
        return null;
    }

    @Override
    public BACnetPropertyIdentifier getPropertyIdentifierArgument() {
        return BACnetPropertyIdentifier.SERIAL_NUMBER;
    }

    public BACnetConstructedDataSerialNumber(BACnetOpeningTag openingTag, BACnetTagHeader peekedTagHeader, BACnetClosingTag closingTag, BACnetApplicationTagCharacterString serialNumber, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
        super(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument);
        this.serialNumber = serialNumber;
        this.tagNumber = tagNumber;
        this.arrayIndexArgument = arrayIndexArgument;
    }

    public BACnetApplicationTagCharacterString getSerialNumber() {
        return this.serialNumber;
    }

    public BACnetApplicationTagCharacterString getActualValue() {
        return this.getSerialNumber();
    }

    @Override
    protected void serializeBACnetConstructedDataChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetConstructedDataSerialNumber", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"serialNumber", (Object)this.serialNumber, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        BACnetApplicationTagCharacterString actualValue = this.getActualValue();
        writeBuffer.writeVirtual("actualValue", (Object)actualValue, new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetConstructedDataSerialNumber", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetConstructedDataSerialNumber _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits += this.serialNumber.getLengthInBits();
    }

    public static BACnetConstructedData.BACnetConstructedDataBuilder staticParseBACnetConstructedDataBuilder(ReadBuffer readBuffer, Short tagNumber, BACnetObjectType objectTypeArgument, BACnetPropertyIdentifier propertyIdentifierArgument, BACnetTagPayloadUnsignedInteger arrayIndexArgument) throws ParseException {
        readBuffer.pullContext("BACnetConstructedDataSerialNumber", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetApplicationTagCharacterString serialNumber = (BACnetApplicationTagCharacterString)FieldReaderFactory.readSimpleField((String)"serialNumber", (DataReader)new DataReaderComplexDefault(() -> (BACnetApplicationTagCharacterString)BACnetApplicationTag.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetApplicationTagCharacterString actualValue = (BACnetApplicationTagCharacterString)FieldReaderFactory.readVirtualField((String)"actualValue", BACnetApplicationTagCharacterString.class, (Object)serialNumber, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetConstructedDataSerialNumber", new WithReaderArgs[0]);
        return new BACnetConstructedDataSerialNumberBuilderImpl(serialNumber, tagNumber, arrayIndexArgument);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetConstructedDataSerialNumber)) {
            return false;
        }
        BACnetConstructedDataSerialNumber that = (BACnetConstructedDataSerialNumber)o;
        return this.getSerialNumber() == that.getSerialNumber() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSerialNumber());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetConstructedDataSerialNumberBuilderImpl
    implements BACnetConstructedData.BACnetConstructedDataBuilder {
        private final BACnetApplicationTagCharacterString serialNumber;
        private final Short tagNumber;
        private final BACnetTagPayloadUnsignedInteger arrayIndexArgument;

        public BACnetConstructedDataSerialNumberBuilderImpl(BACnetApplicationTagCharacterString serialNumber, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
            this.serialNumber = serialNumber;
            this.tagNumber = tagNumber;
            this.arrayIndexArgument = arrayIndexArgument;
        }

        @Override
        public BACnetConstructedDataSerialNumber build(BACnetOpeningTag openingTag, BACnetTagHeader peekedTagHeader, BACnetClosingTag closingTag, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
            BACnetConstructedDataSerialNumber bACnetConstructedDataSerialNumber = new BACnetConstructedDataSerialNumber(openingTag, peekedTagHeader, closingTag, this.serialNumber, tagNumber, arrayIndexArgument);
            return bACnetConstructedDataSerialNumber;
        }
    }
}

