/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetApplicationTagUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetClosingTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConstructedData;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetObjectType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetOpeningTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPropertyIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetConstructedDataSupportedSecurityAlgorithms
extends BACnetConstructedData
implements Message {
    protected final List<BACnetApplicationTagUnsignedInteger> supportedSecurityAlgorithms;
    protected final Short tagNumber;
    protected final BACnetTagPayloadUnsignedInteger arrayIndexArgument;

    @Override
    public BACnetObjectType getObjectTypeArgument() {
        return null;
    }

    @Override
    public BACnetPropertyIdentifier getPropertyIdentifierArgument() {
        return BACnetPropertyIdentifier.SUPPORTED_SECURITY_ALGORITHMS;
    }

    public BACnetConstructedDataSupportedSecurityAlgorithms(BACnetOpeningTag openingTag, BACnetTagHeader peekedTagHeader, BACnetClosingTag closingTag, List<BACnetApplicationTagUnsignedInteger> supportedSecurityAlgorithms, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
        super(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument);
        this.supportedSecurityAlgorithms = supportedSecurityAlgorithms;
        this.tagNumber = tagNumber;
        this.arrayIndexArgument = arrayIndexArgument;
    }

    public List<BACnetApplicationTagUnsignedInteger> getSupportedSecurityAlgorithms() {
        return this.supportedSecurityAlgorithms;
    }

    @Override
    protected void serializeBACnetConstructedDataChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetConstructedDataSupportedSecurityAlgorithms", new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"supportedSecurityAlgorithms", this.supportedSecurityAlgorithms, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetConstructedDataSupportedSecurityAlgorithms", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetConstructedDataSupportedSecurityAlgorithms _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.supportedSecurityAlgorithms != null) {
            for (Message message : this.supportedSecurityAlgorithms) {
                lengthInBits += message.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static BACnetConstructedData.BACnetConstructedDataBuilder staticParseBACnetConstructedDataBuilder(ReadBuffer readBuffer, Short tagNumber, BACnetObjectType objectTypeArgument, BACnetPropertyIdentifier propertyIdentifierArgument, BACnetTagPayloadUnsignedInteger arrayIndexArgument) throws ParseException {
        readBuffer.pullContext("BACnetConstructedDataSupportedSecurityAlgorithms", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        List supportedSecurityAlgorithms = FieldReaderFactory.readTerminatedArrayField((String)"supportedSecurityAlgorithms", (DataReader)new DataReaderComplexDefault(() -> (BACnetApplicationTagUnsignedInteger)BACnetApplicationTag.staticParse(readBuffer), readBuffer), () -> StaticHelper.isBACnetConstructedDataClosingTag(readBuffer, false, tagNumber.shortValue()), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetConstructedDataSupportedSecurityAlgorithms", new WithReaderArgs[0]);
        return new BACnetConstructedDataSupportedSecurityAlgorithmsBuilderImpl(supportedSecurityAlgorithms, tagNumber, arrayIndexArgument);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetConstructedDataSupportedSecurityAlgorithms)) {
            return false;
        }
        BACnetConstructedDataSupportedSecurityAlgorithms that = (BACnetConstructedDataSupportedSecurityAlgorithms)o;
        return this.getSupportedSecurityAlgorithms() == that.getSupportedSecurityAlgorithms() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSupportedSecurityAlgorithms());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetConstructedDataSupportedSecurityAlgorithmsBuilderImpl
    implements BACnetConstructedData.BACnetConstructedDataBuilder {
        private final List<BACnetApplicationTagUnsignedInteger> supportedSecurityAlgorithms;
        private final Short tagNumber;
        private final BACnetTagPayloadUnsignedInteger arrayIndexArgument;

        public BACnetConstructedDataSupportedSecurityAlgorithmsBuilderImpl(List<BACnetApplicationTagUnsignedInteger> supportedSecurityAlgorithms, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
            this.supportedSecurityAlgorithms = supportedSecurityAlgorithms;
            this.tagNumber = tagNumber;
            this.arrayIndexArgument = arrayIndexArgument;
        }

        @Override
        public BACnetConstructedDataSupportedSecurityAlgorithms build(BACnetOpeningTag openingTag, BACnetTagHeader peekedTagHeader, BACnetClosingTag closingTag, Short tagNumber, BACnetTagPayloadUnsignedInteger arrayIndexArgument) {
            BACnetConstructedDataSupportedSecurityAlgorithms bACnetConstructedDataSupportedSecurityAlgorithms = new BACnetConstructedDataSupportedSecurityAlgorithms(openingTag, peekedTagHeader, closingTag, this.supportedSecurityAlgorithms, tagNumber, arrayIndexArgument);
            return bACnetConstructedDataSupportedSecurityAlgorithms;
        }
    }
}

