/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagBitString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagBoolean;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagCharacterString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagDate;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagDouble;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagEnumerated;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagNull;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagObjectIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagOctetString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagReal;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagSignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagTime;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagUnknown;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDataType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseAssertException;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ParseValidationException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class BACnetContextTag
implements Message {
    protected final BACnetTagHeader header;
    protected final Short tagNumberArgument;

    public abstract BACnetDataType getDataType();

    public BACnetContextTag(BACnetTagHeader header, Short tagNumberArgument) {
        this.header = header;
        this.tagNumberArgument = tagNumberArgument;
    }

    public BACnetTagHeader getHeader() {
        return this.header;
    }

    public byte getTagNumber() {
        return this.getHeader().getTagNumber();
    }

    public long getActualLength() {
        return this.getHeader().getActualLength();
    }

    protected abstract void serializeBACnetContextTagChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetContextTag", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"header", (Object)this.header, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        byte tagNumber = this.getTagNumber();
        writeBuffer.writeVirtual("tagNumber", (Object)tagNumber, new WithWriterArgs[0]);
        long actualLength = this.getActualLength();
        writeBuffer.writeVirtual("actualLength", (Object)actualLength, new WithWriterArgs[0]);
        this.serializeBACnetContextTagChild(writeBuffer);
        writeBuffer.popContext("BACnetContextTag", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetContextTag _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits += this.header.getLengthInBits();
    }

    public static BACnetContextTag staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        BACnetDataType dataType;
        Short tagNumberArgument;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 2) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 2, but got " + args.length);
        }
        if (args[0] instanceof Short) {
            tagNumberArgument = (Short)args[0];
        } else if (args[0] instanceof String) {
            tagNumberArgument = Short.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Short or a string which is parseable but was " + args[0].getClass().getName());
        }
        if (args[1] instanceof BACnetDataType) {
            dataType = (BACnetDataType)((Object)args[1]);
        } else if (args[1] instanceof String) {
            dataType = BACnetDataType.valueOf((String)args[1]);
        } else {
            throw new PlcRuntimeException("Argument 1 expected to be of type BACnetDataType or a string which is parseable but was " + args[1].getClass().getName());
        }
        return BACnetContextTag.staticParse(readBuffer, tagNumberArgument, dataType);
    }

    public static BACnetContextTag staticParse(ReadBuffer readBuffer, Short tagNumberArgument, BACnetDataType dataType) throws ParseException {
        readBuffer.pullContext("BACnetContextTag", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetTagHeader header = (BACnetTagHeader)FieldReaderFactory.readSimpleField((String)"header", (DataReader)new DataReaderComplexDefault(() -> BACnetTagHeader.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        if (header.getActualTagNumber() != tagNumberArgument.shortValue()) {
            throw new ParseAssertException("tagnumber doesn't match");
        }
        if (header.getTagClass() != TagClass.CONTEXT_SPECIFIC_TAGS) {
            throw new ParseValidationException("should be a context tag");
        }
        byte tagNumber = (Byte)FieldReaderFactory.readVirtualField((String)"tagNumber", Byte.TYPE, (Object)header.getTagNumber(), (WithReaderArgs[])new WithReaderArgs[0]);
        long actualLength = (Long)FieldReaderFactory.readVirtualField((String)"actualLength", Long.TYPE, (Object)header.getActualLength(), (WithReaderArgs[])new WithReaderArgs[0]);
        if (header.getLengthValueType() == 6 || header.getLengthValueType() == 7) {
            throw new ParseAssertException("length 6 and 7 reserved for opening and closing tag");
        }
        BACnetContextTagBuilder builder = null;
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)BACnetDataType.NULL))) {
            builder = BACnetContextTagNull.staticParseBACnetContextTagBuilder(readBuffer, header, tagNumberArgument, dataType);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)BACnetDataType.BOOLEAN))) {
            builder = BACnetContextTagBoolean.staticParseBACnetContextTagBuilder(readBuffer, header, tagNumberArgument, dataType);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)BACnetDataType.UNSIGNED_INTEGER))) {
            builder = BACnetContextTagUnsignedInteger.staticParseBACnetContextTagBuilder(readBuffer, header, tagNumberArgument, dataType);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)BACnetDataType.SIGNED_INTEGER))) {
            builder = BACnetContextTagSignedInteger.staticParseBACnetContextTagBuilder(readBuffer, header, tagNumberArgument, dataType);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)BACnetDataType.REAL))) {
            builder = BACnetContextTagReal.staticParseBACnetContextTagBuilder(readBuffer, tagNumberArgument, dataType);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)BACnetDataType.DOUBLE))) {
            builder = BACnetContextTagDouble.staticParseBACnetContextTagBuilder(readBuffer, tagNumberArgument, dataType);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)BACnetDataType.OCTET_STRING))) {
            builder = BACnetContextTagOctetString.staticParseBACnetContextTagBuilder(readBuffer, header, tagNumberArgument, dataType);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)BACnetDataType.CHARACTER_STRING))) {
            builder = BACnetContextTagCharacterString.staticParseBACnetContextTagBuilder(readBuffer, header, tagNumberArgument, dataType);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)BACnetDataType.BIT_STRING))) {
            builder = BACnetContextTagBitString.staticParseBACnetContextTagBuilder(readBuffer, header, tagNumberArgument, dataType);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)BACnetDataType.ENUMERATED))) {
            builder = BACnetContextTagEnumerated.staticParseBACnetContextTagBuilder(readBuffer, header, tagNumberArgument, dataType);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)BACnetDataType.DATE))) {
            builder = BACnetContextTagDate.staticParseBACnetContextTagBuilder(readBuffer, tagNumberArgument, dataType);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)BACnetDataType.TIME))) {
            builder = BACnetContextTagTime.staticParseBACnetContextTagBuilder(readBuffer, tagNumberArgument, dataType);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)BACnetDataType.BACNET_OBJECT_IDENTIFIER))) {
            builder = BACnetContextTagObjectIdentifier.staticParseBACnetContextTagBuilder(readBuffer, tagNumberArgument, dataType);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)BACnetDataType.UNKNOWN))) {
            builder = BACnetContextTagUnknown.staticParseBACnetContextTagBuilder(readBuffer, actualLength, tagNumberArgument, dataType);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [dataType=" + (Object)((Object)dataType) + "]");
        }
        readBuffer.closeContext("BACnetContextTag", new WithReaderArgs[0]);
        BACnetContextTag _bACnetContextTag = builder.build(header, tagNumberArgument);
        return _bACnetContextTag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetContextTag)) {
            return false;
        }
        BACnetContextTag that = (BACnetContextTag)o;
        return this.getHeader() == that.getHeader();
    }

    public int hashCode() {
        return Objects.hash(this.getHeader());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface BACnetContextTagBuilder {
        public BACnetContextTag build(BACnetTagHeader var1, Short var2);
    }
}

