/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDataType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadBitString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetContextTagBitString
extends BACnetContextTag
implements Message {
    protected final BACnetTagPayloadBitString payload;
    protected final Short tagNumberArgument;

    @Override
    public BACnetDataType getDataType() {
        return BACnetDataType.BIT_STRING;
    }

    public BACnetContextTagBitString(BACnetTagHeader header, BACnetTagPayloadBitString payload, Short tagNumberArgument) {
        super(header, tagNumberArgument);
        this.payload = payload;
        this.tagNumberArgument = tagNumberArgument;
    }

    public BACnetTagPayloadBitString getPayload() {
        return this.payload;
    }

    @Override
    protected void serializeBACnetContextTagChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetContextTagBitString", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"payload", (Object)this.payload, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetContextTagBitString", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetContextTagBitString _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits += this.payload.getLengthInBits();
    }

    public static BACnetContextTag.BACnetContextTagBuilder staticParseBACnetContextTagBuilder(ReadBuffer readBuffer, BACnetTagHeader header, Short tagNumberArgument, BACnetDataType dataType) throws ParseException {
        readBuffer.pullContext("BACnetContextTagBitString", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetTagPayloadBitString payload = (BACnetTagPayloadBitString)FieldReaderFactory.readSimpleField((String)"payload", (DataReader)new DataReaderComplexDefault(() -> BACnetTagPayloadBitString.staticParse(readBuffer, header.getActualLength()), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetContextTagBitString", new WithReaderArgs[0]);
        return new BACnetContextTagBitStringBuilderImpl(payload, tagNumberArgument);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetContextTagBitString)) {
            return false;
        }
        BACnetContextTagBitString that = (BACnetContextTagBitString)o;
        return this.getPayload() == that.getPayload() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getPayload());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetContextTagBitStringBuilderImpl
    implements BACnetContextTag.BACnetContextTagBuilder {
        private final BACnetTagPayloadBitString payload;
        private final Short tagNumberArgument;

        public BACnetContextTagBitStringBuilderImpl(BACnetTagPayloadBitString payload, Short tagNumberArgument) {
            this.payload = payload;
            this.tagNumberArgument = tagNumberArgument;
        }

        @Override
        public BACnetContextTagBitString build(BACnetTagHeader header, Short tagNumberArgument) {
            BACnetContextTagBitString bACnetContextTagBitString = new BACnetContextTagBitString(header, this.payload, tagNumberArgument);
            return bACnetContextTagBitString;
        }
    }
}

