/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.math.BigInteger;
import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDataType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagPayloadSignedInteger;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetContextTagSignedInteger
extends BACnetContextTag
implements Message {
    protected final BACnetTagPayloadSignedInteger payload;
    protected final Short tagNumberArgument;

    @Override
    public BACnetDataType getDataType() {
        return BACnetDataType.SIGNED_INTEGER;
    }

    public BACnetContextTagSignedInteger(BACnetTagHeader header, BACnetTagPayloadSignedInteger payload, Short tagNumberArgument) {
        super(header, tagNumberArgument);
        this.payload = payload;
        this.tagNumberArgument = tagNumberArgument;
    }

    public BACnetTagPayloadSignedInteger getPayload() {
        return this.payload;
    }

    public BigInteger getActualValue() {
        BigInteger o = this.getPayload().getActualValue();
        if (o instanceof BigInteger) {
            return o;
        }
        return BigInteger.valueOf(((Number)o).longValue());
    }

    @Override
    protected void serializeBACnetContextTagChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetContextTagSignedInteger", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"payload", (Object)this.payload, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        BigInteger actualValue = this.getActualValue();
        writeBuffer.writeVirtual("actualValue", (Object)actualValue, new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetContextTagSignedInteger", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetContextTagSignedInteger _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits += this.payload.getLengthInBits();
    }

    public static BACnetContextTag.BACnetContextTagBuilder staticParseBACnetContextTagBuilder(ReadBuffer readBuffer, BACnetTagHeader header, Short tagNumberArgument, BACnetDataType dataType) throws ParseException {
        readBuffer.pullContext("BACnetContextTagSignedInteger", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetTagPayloadSignedInteger payload = (BACnetTagPayloadSignedInteger)FieldReaderFactory.readSimpleField((String)"payload", (DataReader)new DataReaderComplexDefault(() -> BACnetTagPayloadSignedInteger.staticParse(readBuffer, header.getActualLength()), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BigInteger actualValue = (BigInteger)FieldReaderFactory.readVirtualField((String)"actualValue", BigInteger.class, (Object)payload.getActualValue(), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetContextTagSignedInteger", new WithReaderArgs[0]);
        return new BACnetContextTagSignedIntegerBuilderImpl(payload, tagNumberArgument);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetContextTagSignedInteger)) {
            return false;
        }
        BACnetContextTagSignedInteger that = (BACnetContextTagSignedInteger)o;
        return this.getPayload() == that.getPayload() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getPayload());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetContextTagSignedIntegerBuilderImpl
    implements BACnetContextTag.BACnetContextTagBuilder {
        private final BACnetTagPayloadSignedInteger payload;
        private final Short tagNumberArgument;

        public BACnetContextTagSignedIntegerBuilderImpl(BACnetTagPayloadSignedInteger payload, Short tagNumberArgument) {
            this.payload = payload;
            this.tagNumberArgument = tagNumberArgument;
        }

        @Override
        public BACnetContextTagSignedInteger build(BACnetTagHeader header, Short tagNumberArgument) {
            BACnetContextTagSignedInteger bACnetContextTagSignedInteger = new BACnetContextTagSignedInteger(header, this.payload, tagNumberArgument);
            return bACnetContextTagSignedInteger;
        }
    }
}

