/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetClosingTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetOpeningTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTimeValue;
import org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetDailySchedule
implements Message {
    protected final BACnetOpeningTag openingTag;
    protected final List<BACnetTimeValue> daySchedule;
    protected final BACnetClosingTag closingTag;

    public BACnetDailySchedule(BACnetOpeningTag openingTag, List<BACnetTimeValue> daySchedule, BACnetClosingTag closingTag) {
        this.openingTag = openingTag;
        this.daySchedule = daySchedule;
        this.closingTag = closingTag;
    }

    public BACnetOpeningTag getOpeningTag() {
        return this.openingTag;
    }

    public List<BACnetTimeValue> getDaySchedule() {
        return this.daySchedule;
    }

    public BACnetClosingTag getClosingTag() {
        return this.closingTag;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetDailySchedule", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"openingTag", (Object)this.openingTag, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"daySchedule", this.daySchedule, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"closingTag", (Object)this.closingTag, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetDailySchedule", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetDailySchedule _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.openingTag.getLengthInBits();
        if (this.daySchedule != null) {
            for (Message message : this.daySchedule) {
                lengthInBits += message.getLengthInBits();
            }
        }
        return lengthInBits += this.closingTag.getLengthInBits();
    }

    public static BACnetDailySchedule staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return BACnetDailySchedule.staticParse(readBuffer);
    }

    public static BACnetDailySchedule staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("BACnetDailySchedule", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetOpeningTag openingTag = (BACnetOpeningTag)FieldReaderFactory.readSimpleField((String)"openingTag", (DataReader)new DataReaderComplexDefault(() -> BACnetOpeningTag.staticParse(readBuffer, (short)0), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        List daySchedule = FieldReaderFactory.readTerminatedArrayField((String)"daySchedule", (DataReader)new DataReaderComplexDefault(() -> BACnetTimeValue.staticParse(readBuffer), readBuffer), () -> StaticHelper.isBACnetConstructedDataClosingTag(readBuffer, false, 0), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetClosingTag closingTag = (BACnetClosingTag)FieldReaderFactory.readSimpleField((String)"closingTag", (DataReader)new DataReaderComplexDefault(() -> BACnetClosingTag.staticParse(readBuffer, (short)0), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetDailySchedule", new WithReaderArgs[0]);
        BACnetDailySchedule _bACnetDailySchedule = new BACnetDailySchedule(openingTag, daySchedule, closingTag);
        return _bACnetDailySchedule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetDailySchedule)) {
            return false;
        }
        BACnetDailySchedule that = (BACnetDailySchedule)o;
        return this.getOpeningTag() == that.getOpeningTag() && this.getDaySchedule() == that.getDaySchedule() && this.getClosingTag() == that.getClosingTag();
    }

    public int hashCode() {
        return Objects.hash(this.getOpeningTag(), this.getDaySchedule(), this.getClosingTag());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

