/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagObjectIdentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDataType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetDeviceObjectReference
implements Message {
    protected final BACnetContextTagObjectIdentifier deviceIdentifier;
    protected final BACnetContextTagObjectIdentifier objectIdentifier;

    public BACnetDeviceObjectReference(BACnetContextTagObjectIdentifier deviceIdentifier, BACnetContextTagObjectIdentifier objectIdentifier) {
        this.deviceIdentifier = deviceIdentifier;
        this.objectIdentifier = objectIdentifier;
    }

    public BACnetContextTagObjectIdentifier getDeviceIdentifier() {
        return this.deviceIdentifier;
    }

    public BACnetContextTagObjectIdentifier getObjectIdentifier() {
        return this.objectIdentifier;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetDeviceObjectReference", new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"deviceIdentifier", (Object)this.deviceIdentifier, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"objectIdentifier", (Object)this.objectIdentifier, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetDeviceObjectReference", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetDeviceObjectReference _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.deviceIdentifier != null) {
            lengthInBits += this.deviceIdentifier.getLengthInBits();
        }
        return lengthInBits += this.objectIdentifier.getLengthInBits();
    }

    public static BACnetDeviceObjectReference staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return BACnetDeviceObjectReference.staticParse(readBuffer);
    }

    public static BACnetDeviceObjectReference staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("BACnetDeviceObjectReference", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetContextTagObjectIdentifier deviceIdentifier = (BACnetContextTagObjectIdentifier)FieldReaderFactory.readOptionalField((String)"deviceIdentifier", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagObjectIdentifier)BACnetContextTag.staticParse(readBuffer, (short)0, BACnetDataType.BACNET_OBJECT_IDENTIFIER), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetContextTagObjectIdentifier objectIdentifier = (BACnetContextTagObjectIdentifier)FieldReaderFactory.readSimpleField((String)"objectIdentifier", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagObjectIdentifier)BACnetContextTag.staticParse(readBuffer, (short)1, BACnetDataType.BACNET_OBJECT_IDENTIFIER), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetDeviceObjectReference", new WithReaderArgs[0]);
        BACnetDeviceObjectReference _bACnetDeviceObjectReference = new BACnetDeviceObjectReference(deviceIdentifier, objectIdentifier);
        return _bACnetDeviceObjectReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetDeviceObjectReference)) {
            return false;
        }
        BACnetDeviceObjectReference that = (BACnetDeviceObjectReference)o;
        return this.getDeviceIdentifier() == that.getDeviceIdentifier() && this.getObjectIdentifier() == that.getObjectIdentifier();
    }

    public int hashCode() {
        return Objects.hash(this.getDeviceIdentifier(), this.getObjectIdentifier());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

