/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDataType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetKeyIdentifier
implements Message {
    protected final BACnetContextTagUnsignedInteger algorithm;
    protected final BACnetContextTagUnsignedInteger keyId;

    public BACnetKeyIdentifier(BACnetContextTagUnsignedInteger algorithm, BACnetContextTagUnsignedInteger keyId) {
        this.algorithm = algorithm;
        this.keyId = keyId;
    }

    public BACnetContextTagUnsignedInteger getAlgorithm() {
        return this.algorithm;
    }

    public BACnetContextTagUnsignedInteger getKeyId() {
        return this.keyId;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetKeyIdentifier", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"algorithm", (Object)this.algorithm, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"keyId", (Object)this.keyId, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetKeyIdentifier", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetKeyIdentifier _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.algorithm.getLengthInBits();
        return lengthInBits += this.keyId.getLengthInBits();
    }

    public static BACnetKeyIdentifier staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return BACnetKeyIdentifier.staticParse(readBuffer);
    }

    public static BACnetKeyIdentifier staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("BACnetKeyIdentifier", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetContextTagUnsignedInteger algorithm = (BACnetContextTagUnsignedInteger)FieldReaderFactory.readSimpleField((String)"algorithm", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagUnsignedInteger)BACnetContextTag.staticParse(readBuffer, (short)0, BACnetDataType.UNSIGNED_INTEGER), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetContextTagUnsignedInteger keyId = (BACnetContextTagUnsignedInteger)FieldReaderFactory.readSimpleField((String)"keyId", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagUnsignedInteger)BACnetContextTag.staticParse(readBuffer, (short)1, BACnetDataType.UNSIGNED_INTEGER), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetKeyIdentifier", new WithReaderArgs[0]);
        BACnetKeyIdentifier _bACnetKeyIdentifier = new BACnetKeyIdentifier(algorithm, keyId);
        return _bACnetKeyIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetKeyIdentifier)) {
            return false;
        }
        BACnetKeyIdentifier that = (BACnetKeyIdentifier)o;
        return this.getAlgorithm() == that.getAlgorithm() && this.getKeyId() == that.getKeyId();
    }

    public int hashCode() {
        return Objects.hash(this.getAlgorithm(), this.getKeyId());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

