/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

public enum BACnetLiftFault {
    CONTROLLER_FAULT(0),
    DRIVE_AND_MOTOR_FAULT(1),
    GOVERNOR_AND_SAFETY_GEAR_FAULT(2),
    LIFT_SHAFT_DEVICE_FAULT(3),
    POWER_SUPPLY_FAULT(4),
    SAFETY_INTERLOCK_FAULT(5),
    DOOR_CLOSING_FAULT(6),
    DOOR_OPENING_FAULT(7),
    CAR_STOPPED_OUTSIDE_LANDING_ZONE(8),
    CALL_BUTTON_STUCK(9),
    START_FAILURE(10),
    CONTROLLER_SUPPLY_FAULT(11),
    SELF_TEST_FAILURE(12),
    RUNTIME_LIMIT_EXCEEDED(13),
    POSITION_LOST(14),
    DRIVE_TEMPERATURE_EXCEEDED(15),
    LOAD_MEASUREMENT_FAULT(16),
    VENDOR_PROPRIETARY_VALUE(65535);

    private static final Map<Integer, BACnetLiftFault> map;
    private final int value;

    static {
        map = new HashMap<Integer, BACnetLiftFault>();
        BACnetLiftFault[] bACnetLiftFaultArray = BACnetLiftFault.values();
        int n = bACnetLiftFaultArray.length;
        int n2 = 0;
        while (n2 < n) {
            BACnetLiftFault value = bACnetLiftFaultArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private BACnetLiftFault(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static BACnetLiftFault enumForValue(int value) {
        return map.get(value);
    }

    public static Boolean isDefined(int value) {
        return map.containsKey(value);
    }
}

