/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetClosingTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetLogData;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetLogDataLogDataEntry;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetOpeningTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetLogDataLogData
extends BACnetLogData
implements Message {
    protected final BACnetOpeningTag innerOpeningTag;
    protected final List<BACnetLogDataLogDataEntry> logData;
    protected final BACnetClosingTag innerClosingTag;
    protected final Short tagNumber;

    public BACnetLogDataLogData(BACnetOpeningTag openingTag, BACnetTagHeader peekedTagHeader, BACnetClosingTag closingTag, BACnetOpeningTag innerOpeningTag, List<BACnetLogDataLogDataEntry> logData, BACnetClosingTag innerClosingTag, Short tagNumber) {
        super(openingTag, peekedTagHeader, closingTag, tagNumber);
        this.innerOpeningTag = innerOpeningTag;
        this.logData = logData;
        this.innerClosingTag = innerClosingTag;
        this.tagNumber = tagNumber;
    }

    public BACnetOpeningTag getInnerOpeningTag() {
        return this.innerOpeningTag;
    }

    public List<BACnetLogDataLogDataEntry> getLogData() {
        return this.logData;
    }

    public BACnetClosingTag getInnerClosingTag() {
        return this.innerClosingTag;
    }

    @Override
    protected void serializeBACnetLogDataChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetLogDataLogData", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"innerOpeningTag", (Object)this.innerOpeningTag, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"logData", this.logData, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"innerClosingTag", (Object)this.innerClosingTag, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetLogDataLogData", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BACnetLogDataLogData _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.innerOpeningTag.getLengthInBits();
        if (this.logData != null) {
            for (Message message : this.logData) {
                lengthInBits += message.getLengthInBits();
            }
        }
        return lengthInBits += this.innerClosingTag.getLengthInBits();
    }

    public static BACnetLogData.BACnetLogDataBuilder staticParseBACnetLogDataBuilder(ReadBuffer readBuffer, Short tagNumber) throws ParseException {
        readBuffer.pullContext("BACnetLogDataLogData", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetOpeningTag innerOpeningTag = (BACnetOpeningTag)FieldReaderFactory.readSimpleField((String)"innerOpeningTag", (DataReader)new DataReaderComplexDefault(() -> BACnetOpeningTag.staticParse(readBuffer, (short)1), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        List logData = FieldReaderFactory.readTerminatedArrayField((String)"logData", (DataReader)new DataReaderComplexDefault(() -> BACnetLogDataLogDataEntry.staticParse(readBuffer), readBuffer), () -> StaticHelper.isBACnetConstructedDataClosingTag(readBuffer, false, 1), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetClosingTag innerClosingTag = (BACnetClosingTag)FieldReaderFactory.readSimpleField((String)"innerClosingTag", (DataReader)new DataReaderComplexDefault(() -> BACnetClosingTag.staticParse(readBuffer, (short)1), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetLogDataLogData", new WithReaderArgs[0]);
        return new BACnetLogDataLogDataBuilderImpl(innerOpeningTag, logData, innerClosingTag, tagNumber);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetLogDataLogData)) {
            return false;
        }
        BACnetLogDataLogData that = (BACnetLogDataLogData)o;
        return this.getInnerOpeningTag() == that.getInnerOpeningTag() && this.getLogData() == that.getLogData() && this.getInnerClosingTag() == that.getInnerClosingTag() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getInnerOpeningTag(), this.getLogData(), this.getInnerClosingTag());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BACnetLogDataLogDataBuilderImpl
    implements BACnetLogData.BACnetLogDataBuilder {
        private final BACnetOpeningTag innerOpeningTag;
        private final List<BACnetLogDataLogDataEntry> logData;
        private final BACnetClosingTag innerClosingTag;
        private final Short tagNumber;

        public BACnetLogDataLogDataBuilderImpl(BACnetOpeningTag innerOpeningTag, List<BACnetLogDataLogDataEntry> logData, BACnetClosingTag innerClosingTag, Short tagNumber) {
            this.innerOpeningTag = innerOpeningTag;
            this.logData = logData;
            this.innerClosingTag = innerClosingTag;
            this.tagNumber = tagNumber;
        }

        @Override
        public BACnetLogDataLogData build(BACnetOpeningTag openingTag, BACnetTagHeader peekedTagHeader, BACnetClosingTag closingTag, Short tagNumber) {
            BACnetLogDataLogData bACnetLogDataLogData = new BACnetLogDataLogData(openingTag, peekedTagHeader, closingTag, this.innerOpeningTag, this.logData, this.innerClosingTag, tagNumber);
            return bACnetLogDataLogData;
        }
    }
}

