/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetNetworkType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseAssertException;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ParseValidationException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetNetworkTypeTagged
implements Message {
    protected final BACnetTagHeader header;
    protected final BACnetNetworkType value;
    protected final long proprietaryValue;
    protected final Short tagNumber;
    protected final TagClass tagClass;

    public BACnetNetworkTypeTagged(BACnetTagHeader header, BACnetNetworkType value, long proprietaryValue, Short tagNumber, TagClass tagClass) {
        this.header = header;
        this.value = value;
        this.proprietaryValue = proprietaryValue;
        this.tagNumber = tagNumber;
        this.tagClass = tagClass;
    }

    public BACnetTagHeader getHeader() {
        return this.header;
    }

    public BACnetNetworkType getValue() {
        return this.value;
    }

    public long getProprietaryValue() {
        return this.proprietaryValue;
    }

    public boolean getIsProprietary() {
        return this.getValue() == BACnetNetworkType.VENDOR_PROPRIETARY_VALUE;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetNetworkTypeTagged", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"header", (Object)this.header, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeManualField((String)"value", () -> StaticHelper.writeEnumGeneric(writeBuffer, this.value), (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        boolean isProprietary = this.getIsProprietary();
        writeBuffer.writeVirtual("isProprietary", (Object)isProprietary, new WithWriterArgs[0]);
        FieldWriterFactory.writeManualField((String)"proprietaryValue", () -> StaticHelper.writeProprietaryEnumGeneric(writeBuffer, this.proprietaryValue, isProprietary), (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetNetworkTypeTagged", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetNetworkTypeTagged _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits = (int)((long)(lengthInBits += this.header.getLengthInBits()) + (_value.getIsProprietary() ? 0L : this.header.getActualLength() * 8L));
        lengthInBits = (int)((long)lengthInBits + (_value.getIsProprietary() ? this.header.getActualLength() * 8L : 0L));
        return lengthInBits;
    }

    public static BACnetNetworkTypeTagged staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        TagClass tagClass;
        Short tagNumber;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 2) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 2, but got " + args.length);
        }
        if (args[0] instanceof Short) {
            tagNumber = (Short)args[0];
        } else if (args[0] instanceof String) {
            tagNumber = Short.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Short or a string which is parseable but was " + args[0].getClass().getName());
        }
        if (args[1] instanceof TagClass) {
            tagClass = (TagClass)((Object)args[1]);
        } else if (args[1] instanceof String) {
            tagClass = TagClass.valueOf((String)args[1]);
        } else {
            throw new PlcRuntimeException("Argument 1 expected to be of type TagClass or a string which is parseable but was " + args[1].getClass().getName());
        }
        return BACnetNetworkTypeTagged.staticParse(readBuffer, tagNumber, tagClass);
    }

    public static BACnetNetworkTypeTagged staticParse(ReadBuffer readBuffer, Short tagNumber, TagClass tagClass) throws ParseException {
        readBuffer.pullContext("BACnetNetworkTypeTagged", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetTagHeader header = (BACnetTagHeader)FieldReaderFactory.readSimpleField((String)"header", (DataReader)new DataReaderComplexDefault(() -> BACnetTagHeader.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        if (header.getTagClass() != tagClass) {
            throw new ParseValidationException("tag class doesn't match");
        }
        if (header.getTagClass() != TagClass.APPLICATION_TAGS && header.getActualTagNumber() != tagNumber.shortValue()) {
            throw new ParseAssertException("tagnumber doesn't match");
        }
        BACnetNetworkType value = (BACnetNetworkType)((Object)FieldReaderFactory.readManualField((String)"value", (ReadBuffer)readBuffer, () -> (BACnetNetworkType)((Object)((Object)StaticHelper.readEnumGeneric(readBuffer, header.getActualLength(), BACnetNetworkType.VENDOR_PROPRIETARY_VALUE))), (WithReaderArgs[])new WithReaderArgs[0]));
        boolean isProprietary = (Boolean)FieldReaderFactory.readVirtualField((String)"isProprietary", Boolean.TYPE, (Object)(value == BACnetNetworkType.VENDOR_PROPRIETARY_VALUE ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        long proprietaryValue = (Long)FieldReaderFactory.readManualField((String)"proprietaryValue", (ReadBuffer)readBuffer, () -> StaticHelper.readProprietaryEnumGeneric(readBuffer, header.getActualLength(), isProprietary), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetNetworkTypeTagged", new WithReaderArgs[0]);
        BACnetNetworkTypeTagged _bACnetNetworkTypeTagged = new BACnetNetworkTypeTagged(header, value, proprietaryValue, tagNumber, tagClass);
        return _bACnetNetworkTypeTagged;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetNetworkTypeTagged)) {
            return false;
        }
        BACnetNetworkTypeTagged that = (BACnetNetworkTypeTagged)o;
        return this.getHeader() == that.getHeader() && this.getValue() == that.getValue() && this.getProprietaryValue() == that.getProprietaryValue();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getHeader(), this.getValue(), this.getProprietaryValue()});
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

