/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetObjectType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPriorityValueBitString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPriorityValueBoolean;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPriorityValueCharacterString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPriorityValueConstructedValue;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPriorityValueDate;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPriorityValueDateTime;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPriorityValueDouble;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPriorityValueEnumerated;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPriorityValueInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPriorityValueNull;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPriorityValueObjectidentifier;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPriorityValueOctetString;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPriorityValueReal;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPriorityValueTime;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPriorityValueUnsigned;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetTagHeader;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ParseValidationException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class BACnetPriorityValue
implements Message {
    protected final BACnetTagHeader peekedTagHeader;
    protected final BACnetObjectType objectTypeArgument;

    public BACnetPriorityValue(BACnetTagHeader peekedTagHeader, BACnetObjectType objectTypeArgument) {
        this.peekedTagHeader = peekedTagHeader;
        this.objectTypeArgument = objectTypeArgument;
    }

    public BACnetTagHeader getPeekedTagHeader() {
        return this.peekedTagHeader;
    }

    public short getPeekedTagNumber() {
        return this.getPeekedTagHeader().getActualTagNumber();
    }

    public boolean getPeekedIsContextTag() {
        return this.getPeekedTagHeader().getTagClass() == TagClass.CONTEXT_SPECIFIC_TAGS;
    }

    protected abstract void serializeBACnetPriorityValueChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetPriorityValue", new WithWriterArgs[0]);
        short peekedTagNumber = this.getPeekedTagNumber();
        writeBuffer.writeVirtual("peekedTagNumber", (Object)peekedTagNumber, new WithWriterArgs[0]);
        boolean peekedIsContextTag = this.getPeekedIsContextTag();
        writeBuffer.writeVirtual("peekedIsContextTag", (Object)peekedIsContextTag, new WithWriterArgs[0]);
        this.serializeBACnetPriorityValueChild(writeBuffer);
        writeBuffer.popContext("BACnetPriorityValue", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetPriorityValue _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits;
    }

    public static BACnetPriorityValue staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        BACnetObjectType objectTypeArgument;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof BACnetObjectType) {
            objectTypeArgument = (BACnetObjectType)((Object)args[0]);
        } else if (args[0] instanceof String) {
            objectTypeArgument = BACnetObjectType.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type BACnetObjectType or a string which is parseable but was " + args[0].getClass().getName());
        }
        return BACnetPriorityValue.staticParse(readBuffer, objectTypeArgument);
    }

    public static BACnetPriorityValue staticParse(ReadBuffer readBuffer, BACnetObjectType objectTypeArgument) throws ParseException {
        readBuffer.pullContext("BACnetPriorityValue", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetTagHeader peekedTagHeader = (BACnetTagHeader)FieldReaderFactory.readPeekField((String)"peekedTagHeader", (DataReader)new DataReaderComplexDefault(() -> BACnetTagHeader.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        short peekedTagNumber = (Short)FieldReaderFactory.readVirtualField((String)"peekedTagNumber", Short.TYPE, (Object)peekedTagHeader.getActualTagNumber(), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean peekedIsContextTag = (Boolean)FieldReaderFactory.readVirtualField((String)"peekedIsContextTag", Boolean.TYPE, (Object)(peekedTagHeader.getTagClass() == TagClass.CONTEXT_SPECIFIC_TAGS ? 1 : 0), (WithReaderArgs[])new WithReaderArgs[0]);
        if (peekedIsContextTag && (!peekedIsContextTag || peekedTagHeader.getLengthValueType() == 6 || peekedTagHeader.getLengthValueType() == 7)) {
            throw new ParseValidationException("unexpected opening or closing tag");
        }
        BACnetPriorityValueBuilder builder = null;
        if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)0) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetPriorityValueNull.staticParseBACnetPriorityValueBuilder(readBuffer, objectTypeArgument);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)4) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetPriorityValueReal.staticParseBACnetPriorityValueBuilder(readBuffer, objectTypeArgument);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)9) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetPriorityValueEnumerated.staticParseBACnetPriorityValueBuilder(readBuffer, objectTypeArgument);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)2) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetPriorityValueUnsigned.staticParseBACnetPriorityValueBuilder(readBuffer, objectTypeArgument);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)1) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetPriorityValueBoolean.staticParseBACnetPriorityValueBuilder(readBuffer, objectTypeArgument);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)3) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetPriorityValueInteger.staticParseBACnetPriorityValueBuilder(readBuffer, objectTypeArgument);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)5) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetPriorityValueDouble.staticParseBACnetPriorityValueBuilder(readBuffer, objectTypeArgument);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)11) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetPriorityValueTime.staticParseBACnetPriorityValueBuilder(readBuffer, objectTypeArgument);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)7) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetPriorityValueCharacterString.staticParseBACnetPriorityValueBuilder(readBuffer, objectTypeArgument);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)6) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetPriorityValueOctetString.staticParseBACnetPriorityValueBuilder(readBuffer, objectTypeArgument);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)8) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetPriorityValueBitString.staticParseBACnetPriorityValueBuilder(readBuffer, objectTypeArgument);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)10) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetPriorityValueDate.staticParseBACnetPriorityValueBuilder(readBuffer, objectTypeArgument);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)12) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)false)) {
            builder = BACnetPriorityValueObjectidentifier.staticParseBACnetPriorityValueBuilder(readBuffer, objectTypeArgument);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)0) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)true)) {
            builder = BACnetPriorityValueConstructedValue.staticParseBACnetPriorityValueBuilder(readBuffer, objectTypeArgument);
        } else if (EvaluationHelper.equals((Object)peekedTagNumber, (Object)1) && EvaluationHelper.equals((Object)peekedIsContextTag, (Object)true)) {
            builder = BACnetPriorityValueDateTime.staticParseBACnetPriorityValueBuilder(readBuffer, objectTypeArgument);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [peekedTagNumber=" + peekedTagNumber + " " + "peekedIsContextTag=" + peekedIsContextTag + "]");
        }
        readBuffer.closeContext("BACnetPriorityValue", new WithReaderArgs[0]);
        BACnetPriorityValue _bACnetPriorityValue = builder.build(peekedTagHeader, objectTypeArgument);
        return _bACnetPriorityValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetPriorityValue)) {
            return false;
        }
        BACnetPriorityValue that = (BACnetPriorityValue)o;
        return this.getPeekedTagHeader() == that.getPeekedTagHeader();
    }

    public int hashCode() {
        return Objects.hash(this.getPeekedTagHeader());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface BACnetPriorityValueBuilder {
        public BACnetPriorityValue build(BACnetTagHeader var1, BACnetObjectType var2);
    }
}

