/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetConstructedDataElement;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetContextTagUnsignedInteger;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetDataType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetObjectType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPropertyIdentifierTagged;
import org.apache.plc4x.java.bacnetip.readwrite.TagClass;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetPropertyValue
implements Message {
    protected final BACnetPropertyIdentifierTagged propertyIdentifier;
    protected final BACnetContextTagUnsignedInteger propertyArrayIndex;
    protected final BACnetConstructedDataElement propertyValue;
    protected final BACnetContextTagUnsignedInteger priority;
    protected final BACnetObjectType objectTypeArgument;

    public BACnetPropertyValue(BACnetPropertyIdentifierTagged propertyIdentifier, BACnetContextTagUnsignedInteger propertyArrayIndex, BACnetConstructedDataElement propertyValue, BACnetContextTagUnsignedInteger priority, BACnetObjectType objectTypeArgument) {
        this.propertyIdentifier = propertyIdentifier;
        this.propertyArrayIndex = propertyArrayIndex;
        this.propertyValue = propertyValue;
        this.priority = priority;
        this.objectTypeArgument = objectTypeArgument;
    }

    public BACnetPropertyIdentifierTagged getPropertyIdentifier() {
        return this.propertyIdentifier;
    }

    public BACnetContextTagUnsignedInteger getPropertyArrayIndex() {
        return this.propertyArrayIndex;
    }

    public BACnetConstructedDataElement getPropertyValue() {
        return this.propertyValue;
    }

    public BACnetContextTagUnsignedInteger getPriority() {
        return this.priority;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetPropertyValue", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"propertyIdentifier", (Object)this.propertyIdentifier, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"propertyArrayIndex", (Object)this.propertyArrayIndex, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"propertyValue", (Object)this.propertyValue, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"priority", (Object)this.priority, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetPropertyValue", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetPropertyValue _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.propertyIdentifier.getLengthInBits();
        if (this.propertyArrayIndex != null) {
            lengthInBits += this.propertyArrayIndex.getLengthInBits();
        }
        if (this.propertyValue != null) {
            lengthInBits += this.propertyValue.getLengthInBits();
        }
        if (this.priority != null) {
            lengthInBits += this.priority.getLengthInBits();
        }
        return lengthInBits;
    }

    public static BACnetPropertyValue staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        BACnetObjectType objectTypeArgument;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof BACnetObjectType) {
            objectTypeArgument = (BACnetObjectType)((Object)args[0]);
        } else if (args[0] instanceof String) {
            objectTypeArgument = BACnetObjectType.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type BACnetObjectType or a string which is parseable but was " + args[0].getClass().getName());
        }
        return BACnetPropertyValue.staticParse(readBuffer, objectTypeArgument);
    }

    public static BACnetPropertyValue staticParse(ReadBuffer readBuffer, BACnetObjectType objectTypeArgument) throws ParseException {
        readBuffer.pullContext("BACnetPropertyValue", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetPropertyIdentifierTagged propertyIdentifier = (BACnetPropertyIdentifierTagged)FieldReaderFactory.readSimpleField((String)"propertyIdentifier", (DataReader)new DataReaderComplexDefault(() -> BACnetPropertyIdentifierTagged.staticParse(readBuffer, (short)0, TagClass.CONTEXT_SPECIFIC_TAGS), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetContextTagUnsignedInteger propertyArrayIndex = (BACnetContextTagUnsignedInteger)FieldReaderFactory.readOptionalField((String)"propertyArrayIndex", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagUnsignedInteger)BACnetContextTag.staticParse(readBuffer, (short)1, BACnetDataType.UNSIGNED_INTEGER), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetConstructedDataElement propertyValue = (BACnetConstructedDataElement)FieldReaderFactory.readOptionalField((String)"propertyValue", (DataReader)new DataReaderComplexDefault(() -> BACnetConstructedDataElement.staticParse(readBuffer, objectTypeArgument, propertyIdentifier.getValue(), propertyArrayIndex != null ? propertyArrayIndex.getPayload() : null), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetContextTagUnsignedInteger priority = (BACnetContextTagUnsignedInteger)FieldReaderFactory.readOptionalField((String)"priority", (DataReader)new DataReaderComplexDefault(() -> (BACnetContextTagUnsignedInteger)BACnetContextTag.staticParse(readBuffer, (short)3, BACnetDataType.UNSIGNED_INTEGER), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetPropertyValue", new WithReaderArgs[0]);
        BACnetPropertyValue _bACnetPropertyValue = new BACnetPropertyValue(propertyIdentifier, propertyArrayIndex, propertyValue, priority, objectTypeArgument);
        return _bACnetPropertyValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetPropertyValue)) {
            return false;
        }
        BACnetPropertyValue that = (BACnetPropertyValue)o;
        return this.getPropertyIdentifier() == that.getPropertyIdentifier() && this.getPropertyArrayIndex() == that.getPropertyArrayIndex() && this.getPropertyValue() == that.getPropertyValue() && this.getPriority() == that.getPriority();
    }

    public int hashCode() {
        return Objects.hash(this.getPropertyIdentifier(), this.getPropertyArrayIndex(), this.getPropertyValue(), this.getPriority());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

