/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetClosingTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetObjectType;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetOpeningTag;
import org.apache.plc4x.java.bacnetip.readwrite.BACnetPropertyValue;
import org.apache.plc4x.java.bacnetip.readwrite.utils.StaticHelper;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BACnetPropertyValues
implements Message {
    protected final BACnetOpeningTag innerOpeningTag;
    protected final List<BACnetPropertyValue> data;
    protected final BACnetClosingTag innerClosingTag;
    protected final Short tagNumber;
    protected final BACnetObjectType objectTypeArgument;

    public BACnetPropertyValues(BACnetOpeningTag innerOpeningTag, List<BACnetPropertyValue> data, BACnetClosingTag innerClosingTag, Short tagNumber, BACnetObjectType objectTypeArgument) {
        this.innerOpeningTag = innerOpeningTag;
        this.data = data;
        this.innerClosingTag = innerClosingTag;
        this.tagNumber = tagNumber;
        this.objectTypeArgument = objectTypeArgument;
    }

    public BACnetOpeningTag getInnerOpeningTag() {
        return this.innerOpeningTag;
    }

    public List<BACnetPropertyValue> getData() {
        return this.data;
    }

    public BACnetClosingTag getInnerClosingTag() {
        return this.innerClosingTag;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BACnetPropertyValues", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"innerOpeningTag", (Object)this.innerOpeningTag, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"data", this.data, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"innerClosingTag", (Object)this.innerClosingTag, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BACnetPropertyValues", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        BACnetPropertyValues _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.innerOpeningTag.getLengthInBits();
        if (this.data != null) {
            for (Message message : this.data) {
                lengthInBits += message.getLengthInBits();
            }
        }
        return lengthInBits += this.innerClosingTag.getLengthInBits();
    }

    public static BACnetPropertyValues staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        BACnetObjectType objectTypeArgument;
        Short tagNumber;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 2) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 2, but got " + args.length);
        }
        if (args[0] instanceof Short) {
            tagNumber = (Short)args[0];
        } else if (args[0] instanceof String) {
            tagNumber = Short.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Short or a string which is parseable but was " + args[0].getClass().getName());
        }
        if (args[1] instanceof BACnetObjectType) {
            objectTypeArgument = (BACnetObjectType)((Object)args[1]);
        } else if (args[1] instanceof String) {
            objectTypeArgument = BACnetObjectType.valueOf((String)args[1]);
        } else {
            throw new PlcRuntimeException("Argument 1 expected to be of type BACnetObjectType or a string which is parseable but was " + args[1].getClass().getName());
        }
        return BACnetPropertyValues.staticParse(readBuffer, tagNumber, objectTypeArgument);
    }

    public static BACnetPropertyValues staticParse(ReadBuffer readBuffer, Short tagNumber, BACnetObjectType objectTypeArgument) throws ParseException {
        readBuffer.pullContext("BACnetPropertyValues", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        BACnetOpeningTag innerOpeningTag = (BACnetOpeningTag)FieldReaderFactory.readSimpleField((String)"innerOpeningTag", (DataReader)new DataReaderComplexDefault(() -> BACnetOpeningTag.staticParse(readBuffer, (short)tagNumber), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        List data = FieldReaderFactory.readTerminatedArrayField((String)"data", (DataReader)new DataReaderComplexDefault(() -> BACnetPropertyValue.staticParse(readBuffer, objectTypeArgument), readBuffer), () -> StaticHelper.isBACnetConstructedDataClosingTag(readBuffer, false, tagNumber.shortValue()), (WithReaderArgs[])new WithReaderArgs[0]);
        BACnetClosingTag innerClosingTag = (BACnetClosingTag)FieldReaderFactory.readSimpleField((String)"innerClosingTag", (DataReader)new DataReaderComplexDefault(() -> BACnetClosingTag.staticParse(readBuffer, (short)tagNumber), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BACnetPropertyValues", new WithReaderArgs[0]);
        BACnetPropertyValues _bACnetPropertyValues = new BACnetPropertyValues(innerOpeningTag, data, innerClosingTag, tagNumber, objectTypeArgument);
        return _bACnetPropertyValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BACnetPropertyValues)) {
            return false;
        }
        BACnetPropertyValues that = (BACnetPropertyValues)o;
        return this.getInnerOpeningTag() == that.getInnerOpeningTag() && this.getData() == that.getData() && this.getInnerClosingTag() == that.getInnerClosingTag();
    }

    public int hashCode() {
        return Objects.hash(this.getInnerOpeningTag(), this.getData(), this.getInnerClosingTag());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

